/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.msc.service.ServiceName;

public final class ConnectorServices {
    private static Map<String, Set<ServiceName>> resourceAdapterXmlServiceNames = new ConcurrentHashMap<String, Set<ServiceName>>();
    private static Map<String, Set<ServiceName>> resourceAdapterServiceNames = new ConcurrentHashMap<String, Set<ServiceName>>();
    public static final ServiceName CONNECTOR_CONFIG_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "config"});
    public static final ServiceName DEFAULT_BOOTSTRAP_CONTEXT_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "defaultbootstrapcontext"});
    public static final ServiceName TRANSACTION_INTEGRATION_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "transactionintegration"});
    public static final ServiceName WORKMANAGER_SERVICE = ServiceName.JBOSS.append(new String[]{"connector", "workmanager"});
    public static final ServiceName RESOURCE_ADAPTER_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"ra"});
    public static final ServiceName RESOURCE_ADAPTER_XML_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"raxml"});
    public static final ServiceName RESOURCE_ADAPTER_REGISTRY_SERVICE = ServiceName.JBOSS.append(new String[]{"raregistry"});
    public static final ServiceName RESOURCE_ADAPTER_ACTIVATOR_SERVICE = ServiceName.JBOSS.append(new String[]{"raactivator"});
    public static final ServiceName IRONJACAMAR_MDR = ServiceName.JBOSS.append(new String[]{"ironjacamar", "mdr"});
    public static final ServiceName RA_REPOSISTORY_SERVICE = ServiceName.JBOSS.append(new String[]{"rarepository"});
    public static final ServiceName MANAGEMENT_REPOSISTORY_SERVICE = ServiceName.JBOSS.append(new String[]{"management_repository"});
    public static final ServiceName RESOURCEADAPTERS_SERVICE = ServiceName.JBOSS.append(new String[]{"resourceadapters"});
    public static final ServiceName DATASOURCES_SERVICE = ServiceName.JBOSS.append(new String[]{"datasources"});
    public static final ServiceName JDBC_DRIVER_REGISTRY_SERVICE = ServiceName.JBOSS.append(new String[]{"jdbc-driver", "registry"});
    public static final ServiceName CCM_SERVICE = ServiceName.JBOSS.append(new String[]{"cached-connection-manager"});

    private ConnectorServices() {
    }

    public static <T> T notNull(T value) {
        if (value == null) {
            throw new IllegalStateException("Service not started");
        }
        return value;
    }

    public static synchronized ServiceName getNextValidResourceAdapterXmlServiceName(String raName) {
        ServiceName serviceName = null;
        if (resourceAdapterXmlServiceNames.get(raName) == null) {
            serviceName = RESOURCE_ADAPTER_XML_SERVICE_PREFIX.append(new String[]{raName + "_1"});
            HashSet<ServiceName> serviceNames = new HashSet<ServiceName>(1);
            serviceNames.add(serviceName);
            resourceAdapterXmlServiceNames.put(raName, serviceNames);
        } else {
            serviceName = RESOURCE_ADAPTER_XML_SERVICE_PREFIX.append(new String[]{raName + "_" + String.valueOf(resourceAdapterXmlServiceNames.get(raName).size() + 1)});
            resourceAdapterXmlServiceNames.get(raName).add(serviceName);
        }
        return serviceName;
    }

    public static Set<ServiceName> getResourceAdapterXmlServiceName(String raName) {
        return resourceAdapterXmlServiceNames.get(raName);
    }

    public static synchronized ServiceName getNextValidResourceAdapterServiceName(String raName) {
        ServiceName serviceName = null;
        if (resourceAdapterServiceNames.get(raName) == null) {
            serviceName = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{raName + "_1"});
            HashSet<ServiceName> serviceNames = new HashSet<ServiceName>(1);
            serviceNames.add(serviceName);
            resourceAdapterServiceNames.put(raName, serviceNames);
        } else {
            serviceName = RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{raName + "_" + String.valueOf(resourceAdapterXmlServiceNames.get(raName).size() + 1)});
            resourceAdapterServiceNames.get(raName).add(serviceName);
        }
        return serviceName;
    }

    public static Set<ServiceName> getResourceAdapteServiceName(String raName) {
        return resourceAdapterServiceNames.get(raName);
    }
}

