/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.logging.Logger;

public final class ResourceAdapterDeploymentRegistryImpl
implements ResourceAdapterDeploymentRegistry {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.connector.registry");
    private Set<ResourceAdapterDeployment> deployments = new HashSet<ResourceAdapterDeployment>();

    @Override
    public void registerResourceAdapterDeployment(ResourceAdapterDeployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        log.tracef("Adding deployment: %s", (Object)deployment);
        this.deployments.add(deployment);
    }

    @Override
    public void unregisterResourceAdapterDeployment(ResourceAdapterDeployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        log.tracef("Removing deployment: %s", (Object)deployment);
        this.deployments.remove(deployment);
    }

    @Override
    public Set<ResourceAdapterDeployment> getResourceAdapterDeployments() {
        return Collections.unmodifiableSet(this.deployments);
    }
}

