/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.controller.AbstractModelController;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ControllerTransactionContext;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelProvider;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextFactory;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationControllerContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersisterProvider;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public class BasicModelController
extends AbstractModelController<OperationControllerContext>
implements ModelController {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.controller");
    private final Lock writeLock = new ReentrantLock(true);
    private final ModelNodeRegistration registry;
    private final ModelNode model;
    private final ConfigurationPersister configurationPersister;
    private final ModelProvider modelSource = new ModelProvider(){

        @Override
        public ModelNode getModel() {
            return BasicModelController.this.model;
        }
    };
    private final OperationContextFactory contextFactory = new OperationContextFactory(){

        @Override
        public OperationContext getOperationContext(ModelProvider modelSource, PathAddress address, OperationHandler operationHandler, Operation operation) {
            ModelNode subModel = BasicModelController.this.getOperationSubModel(modelSource, operationHandler, address);
            return BasicModelController.this.getOperationContext(subModel, operationHandler, operation, modelSource);
        }
    };
    private final ConfigurationPersisterProvider configPersisterProvider = new ConfigurationPersisterProvider(){

        @Override
        public ConfigurationPersister getConfigurationPersister() {
            return BasicModelController.this.configurationPersister;
        }
    };

    protected BasicModelController(ConfigurationPersister configurationPersister) {
        this(new ModelNode().setEmptyObject(), configurationPersister, (DescriptionProvider)null);
    }

    protected BasicModelController(ConfigurationPersister configurationPersister, DescriptionProvider rootDescriptionProvider) {
        this(new ModelNode().setEmptyObject(), configurationPersister, rootDescriptionProvider);
    }

    protected BasicModelController(ModelNode model, ConfigurationPersister configurationPersister, DescriptionProvider rootDescriptionProvider) {
        this(model, configurationPersister, BasicModelController.createRootRegistry(rootDescriptionProvider));
    }

    protected BasicModelController(ModelNode model, ConfigurationPersister configurationPersister, ModelNodeRegistration rootRegistry) {
        this.model = model;
        this.configurationPersister = configurationPersister;
        this.registry = rootRegistry;
    }

    private static ModelNodeRegistration createRootRegistry(DescriptionProvider rootDescriptionProvider) {
        if (rootDescriptionProvider == null) {
            rootDescriptionProvider = new DescriptionProvider(){

                @Override
                public ModelNode getModelDescription(Locale locale) {
                    return new ModelNode();
                }
            };
        }
        return ModelNodeRegistration.Factory.create(rootDescriptionProvider);
    }

    protected OperationHandler getHandler(PathAddress address, String name) {
        return this.registry.getOperationHandler(address, name);
    }

    protected ModelProvider getModelProvider() {
        return this.modelSource;
    }

    protected OperationContextFactory getOperationContextFactory() {
        return this.contextFactory;
    }

    protected ConfigurationPersisterProvider getConfigurationPersisterProvider() {
        return this.configPersisterProvider;
    }

    @Override
    protected OperationControllerContext getOperationControllerContext(Operation operation) {
        return new OperationControllerContext(){

            @Override
            public ModelProvider getModelProvider() {
                return BasicModelController.this.modelSource;
            }

            @Override
            public OperationContextFactory getOperationContextFactory() {
                return BasicModelController.this.contextFactory;
            }

            @Override
            public ConfigurationPersisterProvider getConfigurationPersisterProvider() {
                return BasicModelController.this.configPersisterProvider;
            }

            @Override
            public ControllerTransactionContext getControllerTransactionContext() {
                return null;
            }

            @Override
            public boolean lockInterruptibly() throws InterruptedException {
                BasicModelController.this.writeLock.lockInterruptibly();
                return true;
            }

            @Override
            public void unlock() {
                BasicModelController.this.writeLock.unlock();
            }
        };
    }

    @Override
    public OperationResult execute(Operation operation, ResultHandler handler, OperationControllerContext operationExecutionContext) {
        return this.execute(operation, handler, operationExecutionContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OperationResult execute(Operation operation, ResultHandler handler, OperationControllerContext operationExecutionContext, boolean resolve) {
        boolean locked = false;
        try {
            PathAddress address = PathAddress.pathAddress(operation.getOperation().get("address"));
            boolean multiTarget = address.isMultiTarget();
            if (multiTarget && resolve) {
                MultiTargetAction action = new MultiTargetAction(address);
                OperationResult operationResult = action.execute(operation, handler, operationExecutionContext);
                return operationResult;
            }
            ProxyController proxyExecutor = this.registry.getProxyController(address);
            if (proxyExecutor != null) {
                Operation newContext = operation.clone();
                newContext.getOperation().get("address").set(address.subAddress(proxyExecutor.getProxyNodeAddress().size()).toModelNode());
                OperationResult operationResult = proxyExecutor.execute(newContext, handler);
                return operationResult;
            }
            if (this.isMultiStepOperation(operation.getOperation(), address)) {
                MultiStepOperationController multistepController = this.getMultiStepOperationController(operation, handler, operationExecutionContext);
                OperationResult operationResult = multistepController.execute(handler);
                return operationResult;
            }
            OperationHandler operationHandler = this.getHandlerForOperation(operation.getOperation(), address);
            if (!this.isReadOnly(operationHandler)) {
                locked = BasicModelController.acquireWriteLock(operationExecutionContext);
            }
            OperationContext context = operationExecutionContext.getOperationContextFactory().getOperationContext(operationExecutionContext.getModelProvider(), address, operationHandler, operation);
            OperationResult operationResult = this.doExecute(context, operation, operationHandler, handler, address, operationExecutionContext);
            return operationResult;
        }
        catch (OperationFailedException e) {
            log.warnf((Throwable)e, "operation (%s) failed - address: (%s)", (Object)operation.getOperation().get("operation"), (Object)operation.getOperation().get("address"));
            handler.handleFailed(e.getFailureDescription());
            BasicOperationResult basicOperationResult = new BasicOperationResult();
            return basicOperationResult;
        }
        catch (Throwable t) {
            log.errorf(t, "operation (%s) failed - address: (%s)", (Object)operation.getOperation().get("operation"), (Object)operation.getOperation().get("address"));
            handler.handleFailed(this.getFailureResult(t));
            BasicOperationResult basicOperationResult = new BasicOperationResult();
            return basicOperationResult;
        }
        finally {
            if (locked) {
                operationExecutionContext.unlock();
            }
        }
    }

    protected OperationHandler getHandlerForOperation(ModelNode operation, PathAddress address) throws OperationFailedException {
        String operationName = operation.require("operation").asString();
        OperationHandler operationHandler = this.registry.getOperationHandler(address, operationName);
        if (operationHandler == null) {
            throw new OperationFailedException(new ModelNode().set(String.format("No handler for %s at address %s", operationName, address)));
        }
        return operationHandler;
    }

    protected boolean isReadOnly(OperationHandler operationHandler) {
        return operationHandler instanceof ModelQueryOperationHandler && !(operationHandler instanceof ModelUpdateOperationHandler);
    }

    protected MultiStepOperationController getMultiStepOperationController(Operation operation, ResultHandler handler, OperationControllerContext operationExecutionContext) throws OperationFailedException {
        return new MultiStepOperationController(operation, handler, operationExecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelNode getOperationSubModel(ModelProvider modelSource, OperationHandler operationHandler, PathAddress address) {
        ModelNode subModel;
        if (operationHandler instanceof ModelAddOperationHandler) {
            this.validateNewAddress(address);
            subModel = new ModelNode();
        } else if (operationHandler instanceof ModelQueryOperationHandler) {
            ModelNode model;
            ModelNode modelNode = model = modelSource.getModel();
            synchronized (modelNode) {
                subModel = address.navigate(model, false).clone();
            }
        } else {
            subModel = null;
        }
        return subModel;
    }

    protected boolean isMultiStepOperation(ModelNode operation, PathAddress address) {
        return address.size() == 0 && "composite".equals(operation.require("operation").asString());
    }

    protected void persistConfiguration(ModelNode model, ConfigurationPersisterProvider configurationPersisterFactory) {
        ConfigurationPersister configurationPersister = configurationPersisterFactory.getConfigurationPersister();
        if (configurationPersister != null) {
            try {
                configurationPersister.store(model);
            }
            catch (ConfigurationPersistenceException e) {
                log.warnf((Throwable)e, "Failed to persist configuration change: %s", (Object)e);
            }
        }
    }

    protected void registerInternalOperations() {
        if (this.configurationPersister != null) {
            XmlMarshallingHandler handler = new XmlMarshallingHandler(this.configurationPersister, this.model);
            this.registry.registerOperationHandler("read-config-as-xml", handler, handler, false, OperationEntry.EntryType.PRIVATE);
        }
    }

    protected OperationContext getOperationContext(ModelNode subModel, OperationHandler operationHandler, Operation executionContext, ModelProvider modelProvider) {
        return new OperationContextImpl(this, this.getRegistry(), subModel, modelProvider, (OperationAttachments)executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OperationResult doExecute(OperationContext operationHandlerContext, Operation operation, OperationHandler operationHandler, ResultHandler resultHandler, PathAddress address, OperationControllerContext operationControllerContext) throws OperationFailedException {
        OperationResult result = operationHandler.execute(operationHandlerContext, operation.getOperation(), resultHandler);
        if (operationHandler instanceof ModelUpdateOperationHandler) {
            ModelNode model;
            ModelNode modelNode = model = operationControllerContext.getModelProvider().getModel();
            synchronized (modelNode) {
                if (operationHandler instanceof ModelRemoveOperationHandler) {
                    address.remove(model);
                } else {
                    address.navigate(model, true).set(operationHandlerContext.getSubModel());
                }
                this.persistConfiguration(model, operationControllerContext.getConfigurationPersisterProvider());
            }
        }
        return result;
    }

    protected ModelNodeRegistration getRegistry() {
        return this.registry;
    }

    protected ModelNode getModel() {
        return this.model;
    }

    protected void validateNewAddress(PathAddress address) {
        if (address.size() == 0) {
            throw new IllegalStateException("Resource at address " + address + " already exists");
        }
        ModelNode node = this.model;
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        for (PathElement element : address.subAddress(0, address.size() - 1)) {
            try {
                elements.add(element);
                node = node.require(element.getKey()).require(element.getValue());
            }
            catch (NoSuchElementException nsee) {
                PathAddress ancestor = PathAddress.pathAddress(elements);
                throw new IllegalStateException("Cannot add resource at address " + address + " because ancestor resource " + ancestor + " does not exist");
            }
        }
        PathElement last = address.getLastElement();
        if (!node.has(last.getKey())) {
            throw new IllegalStateException("Cannot add resource at address " + address + " because parent resource does not have child " + last.getKey());
        }
        if (node.get(last.getKey()).has(last.getValue()) && node.get(last.getKey()).get(last.getValue()).isDefined()) {
            throw new IllegalStateException("Resource at address " + address + " already exists");
        }
    }

    private static boolean acquireWriteLock(OperationControllerContext context) throws OperationFailedException {
        try {
            return context.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException(new ModelNode().set("Interrupted while attempting to acquire the operation execution write lock"));
        }
    }

    protected final class MultiTargetAction {
        private final PathAddress address;

        protected MultiTargetAction(PathAddress address) {
            this.address = address;
        }

        /*
         * Exception decompiling
         */
        protected OperationResult execute(Operation operation, ResultHandler handler, OperationControllerContext operationExecutionContext) throws OperationFailedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 7[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected OperationResult executeMultiOperation(Collection<ModelNode> resolved, Operation operation, ResultHandler handler, OperationControllerContext operationExecutionContext) throws OperationFailedException {
            if (resolved.isEmpty()) {
                handler.handleResultComplete();
                return new BasicOperationResult();
            }
            ModelNode multiStep = new ModelNode();
            for (ModelNode a : resolved) {
                ModelNode newOperation = operation.getOperation().clone();
                newOperation.get("address").set(a);
                multiStep.get("steps").add(newOperation);
            }
            Operation multiContext = operation.clone(multiStep);
            MultiStepOperationController multistepController = BasicModelController.this.getMultiStepOperationController(multiContext, handler, operationExecutionContext);
            multistepController.resolve = false;
            return multistepController.execute(handler);
        }
    }

    protected static class StepResultHandler
    implements ResultHandler {
        private final Integer id;
        private final ModelNode stepResult = new ModelNode();
        private final MultiStepOperationController compositeContext;
        private volatile boolean terminalState;

        public StepResultHandler(Integer id, MultiStepOperationController stepContext) {
            this.id = id;
            this.compositeContext = stepContext;
        }

        @Override
        public void handleResultFragment(String[] location, ModelNode result) {
            this.stepResult.get(location).set(result);
        }

        @Override
        public void handleResultComplete() {
            this.compositeContext.recordResult(this.id, this.stepResult);
            this.terminalState = true;
        }

        @Override
        public void handleFailed(ModelNode failureDescription) {
            this.compositeContext.recordFailure(this.id, failureDescription);
            this.terminalState = true;
        }

        @Override
        public void handleCancellation() {
            this.compositeContext.recordCancellation(this.id);
            this.terminalState = true;
        }

        public boolean isTerminalState() {
            return this.terminalState;
        }
    }

    protected class MultiStepOperationController
    implements ModelProvider,
    OperationContextFactory,
    ConfigurationPersisterProvider {
        private final ParameterValidator stepsValidator = new ModelTypeValidator(ModelType.LIST);
        protected final Operation operation;
        protected final boolean rollbackOnRuntimeFailure;
        protected final ResultHandler resultHandler;
        protected final List<ModelNode> steps;
        protected final AtomicInteger unfinishedCount = new AtomicInteger();
        protected final ModelNode resultsNode = new ModelNode();
        protected final Map<Integer, ModelNode> rollbackOps = new HashMap<Integer, ModelNode>();
        protected final Map<Integer, StepResultHandler> stepResultHandlers = new HashMap<Integer, StepResultHandler>();
        protected final Map<Integer, String> rollbackStepNames = new HashMap<Integer, String>();
        protected final AtomicBoolean modelComplete = new AtomicBoolean(false);
        protected boolean hasFailures = false;
        protected ModelNode overallFailure;
        protected final ModelProvider modelSource;
        protected final ModelNode localModel;
        protected boolean modelUpdated;
        protected int currentOperation;
        protected final Map<Integer, RuntimeTask> runtimeTasks = new HashMap<Integer, RuntimeTask>();
        protected final ConfigurationPersisterProvider injectedConfigPersisterProvider;
        protected final ConfigurationPersister localConfigPersister = new ConfigurationPersister(){

            @Override
            public void store(ModelNode model) throws ConfigurationPersistenceException {
                MultiStepOperationController.this.modelUpdated = true;
            }

            @Override
            public void marshallAsXml(ModelNode model, OutputStream output) throws ConfigurationPersistenceException {
                BasicModelController.this.configurationPersister.marshallAsXml(model, output);
            }

            @Override
            public List<ModelNode> load() throws ConfigurationPersistenceException {
                throw new UnsupportedOperationException("load() should not be called as part of operation handling");
            }

            @Override
            public void successfulBoot() throws ConfigurationPersistenceException {
            }

            @Override
            public String snapshot() {
                return null;
            }

            @Override
            public ConfigurationPersister.SnapshotInfo listSnapshots() {
                return NULL_SNAPSHOT_INFO;
            }

            @Override
            public void deleteSnapshot(String name) {
            }
        };
        protected final OperationControllerContext injectedOperationControllerContext;
        protected final OperationControllerContext localOperationExecutionContext = new OperationControllerContext(){

            @Override
            public ModelProvider getModelProvider() {
                return MultiStepOperationController.this;
            }

            @Override
            public OperationContextFactory getOperationContextFactory() {
                return MultiStepOperationController.this;
            }

            @Override
            public ConfigurationPersisterProvider getConfigurationPersisterProvider() {
                return MultiStepOperationController.this;
            }

            @Override
            public ControllerTransactionContext getControllerTransactionContext() {
                return null;
            }

            @Override
            public boolean lockInterruptibly() throws InterruptedException {
                return false;
            }

            @Override
            public void unlock() {
            }
        };
        protected boolean resolve = true;

        protected MultiStepOperationController(Operation operation, ResultHandler resultHandler, OperationControllerContext operationControllerContext) throws OperationFailedException {
            this(operation, resultHandler, operationControllerContext, operationControllerContext.getModelProvider(), operationControllerContext.getConfigurationPersisterProvider());
        }

        protected MultiStepOperationController(Operation operation, ResultHandler resultHandler, OperationControllerContext injectedOperationControllerContext, ModelProvider modelProvider, ConfigurationPersisterProvider injectedConfigPersisterProvider) throws OperationFailedException {
            this.operation = operation;
            ModelNode operationNode = operation.getOperation();
            this.stepsValidator.validateParameter("steps", operationNode.get("steps"));
            this.resultHandler = resultHandler;
            this.steps = operationNode.require("steps").asList();
            this.unfinishedCount.set(this.steps.size());
            this.rollbackOnRuntimeFailure = !operationNode.hasDefined("operation-headers") || !operationNode.get("operation-headers").hasDefined("rollback-on-runtime-failure") || operationNode.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).asBoolean();
            this.modelSource = modelProvider;
            this.localModel = this.modelSource.getModel().clone();
            this.injectedConfigPersisterProvider = injectedConfigPersisterProvider;
            this.injectedOperationControllerContext = injectedOperationControllerContext;
            for (int i = 0; i < this.unfinishedCount.get(); ++i) {
                ModelNode stepResult = this.getStepResultNode(i);
                stepResult.get("outcome");
                stepResult.get("address").set(this.steps.get(i).get("address"));
                stepResult.get("result");
            }
        }

        protected void handleFailures() {
            for (Property prop : this.resultsNode.asPropertyList()) {
                ModelNode result = prop.getValue();
                if (result.hasDefined("outcome") && "cancelled".equals(result.get("outcome").asString())) continue;
                if (!this.modelComplete.get()) {
                    result.get("rolled-back").set(true);
                }
                result.get("outcome").set("failed");
                this.resultsNode.get(prop.getName()).set(result);
            }
            this.resultHandler.handleResultFragment(ResultHandler.EMPTY_LOCATION, this.resultsNode);
            ModelNode failureMsg = this.overallFailure == null ? this.getOverallFailureDescription() : this.overallFailure;
            this.resultHandler.handleFailed(failureMsg);
        }

        protected final ModelNode getOverallCompensatingOperation() {
            ModelNode compensatingOp = new ModelNode();
            compensatingOp.get("operation").set("composite");
            compensatingOp.get("address").setEmptyList();
            ModelNode compSteps = compensatingOp.get("steps");
            compSteps.setEmptyList();
            int rollbackIndex = 0;
            for (int i = this.steps.size() - 1; i >= 0; --i) {
                Integer id = i;
                ModelNode compStep = this.rollbackOps.get(id);
                if (compStep == null || !compStep.isDefined()) continue;
                compSteps.add(compStep);
                this.rollbackStepNames.put(id, this.getStepKey(rollbackIndex));
                ++rollbackIndex;
            }
            if (rollbackIndex > 0) {
                compensatingOp.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
                return compensatingOp;
            }
            return new ModelNode();
        }

        protected void recordModelComplete() {
            this.modelComplete.set(true);
            if (this.isModelUpdated()) {
                this.updateModelAndPersist();
            }
            if (this.unfinishedCount.get() == 0) {
                this.handleSuccess();
            }
        }

        protected boolean isModelUpdated() {
            return this.modelUpdated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateModelAndPersist() {
            ModelNode model;
            ModelNode modelNode = model = this.modelSource.getModel();
            synchronized (modelNode) {
                model.set(this.localModel);
                BasicModelController.this.persistConfiguration(model, this.injectedConfigPersisterProvider);
            }
        }

        protected final String getStepKey(int id) {
            return "step-" + (id + 1);
        }

        protected OperationResult executeStep(ModelNode step, ResultHandler stepResultHandler) {
            return BasicModelController.this.execute(this.operation.clone(step), stepResultHandler, this.localOperationExecutionContext, this.resolve);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OperationResult execute(ResultHandler handler) throws OperationFailedException {
            boolean locked = false;
            try {
                if (this.isReadOnly(this.operation.getOperation())) {
                    locked = BasicModelController.acquireWriteLock(this.injectedOperationControllerContext);
                }
                for (int i = 0; i < this.steps.size(); ++i) {
                    this.currentOperation = i;
                    ModelNode step = this.steps.get(i).clone();
                    step.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
                    if (this.hasFailures()) {
                        this.recordCancellation(i);
                        continue;
                    }
                    Integer id = i;
                    ResultHandler stepResultHandler = this.getStepResultHandler(id);
                    OperationResult result = this.executeStep(step, stepResultHandler);
                    this.recordRollbackOp(id, result.getCompensatingOperation());
                }
                if (this.hasFailures()) {
                    this.handleFailures();
                    BasicOperationResult i = new BasicOperationResult();
                    return i;
                }
                ModelNode compensatingOp = this.getOverallCompensatingOperation();
                this.recordModelComplete();
                BasicOperationResult basicOperationResult = new BasicOperationResult(compensatingOp);
                return basicOperationResult;
            }
            finally {
                if (locked) {
                    this.injectedOperationControllerContext.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recordResult(Integer id, ModelNode result) {
            ModelNode rollback = this.rollbackOps.get(id);
            ModelNode modelNode = this.resultsNode;
            synchronized (modelNode) {
                ModelNode stepResult = this.getStepResultNode(id);
                stepResult.get("outcome").set("success");
                stepResult.get("result").set(result);
                stepResult.get("compensating-operation").set(rollback == null ? new ModelNode() : rollback);
            }
            if (this.unfinishedCount.decrementAndGet() == 0 && this.modelComplete.get()) {
                this.processComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recordFailure(Integer id, ModelNode failureDescription) {
            ModelNode modelNode = this.resultsNode;
            synchronized (modelNode) {
                ModelNode stepResult = this.getStepResultNode(id);
                stepResult.get("outcome").set("failed");
                if (stepResult.has("result") && !stepResult.hasDefined("result")) {
                    stepResult.remove("result");
                }
                stepResult.get("failure-description").set(failureDescription);
            }
            this.hasFailures = true;
            if (this.unfinishedCount.decrementAndGet() == 0 && this.modelComplete.get()) {
                this.processComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recordCancellation(Integer id) {
            ModelNode modelNode = this.resultsNode;
            synchronized (modelNode) {
                ModelNode stepResult = this.getStepResultNode(id);
                stepResult.get("outcome").set("cancelled");
                if (stepResult.has("result")) {
                    stepResult.remove("result");
                }
            }
            if (this.unfinishedCount.decrementAndGet() == 0 && this.modelComplete.get()) {
                this.processComplete();
            }
        }

        private boolean isReadOnly(ModelNode operation) throws OperationFailedException {
            List opSteps = operation.require("steps").asList();
            for (ModelNode step : opSteps) {
                OperationHandler handler;
                PathAddress stepAddr;
                if (!(BasicModelController.this.isMultiStepOperation(step, stepAddr = PathAddress.pathAddress(step.get("address"))) ? !this.isReadOnly(step) : !BasicModelController.this.isReadOnly(handler = BasicModelController.this.getHandlerForOperation(step, stepAddr)))) continue;
                return false;
            }
            return true;
        }

        private ResultHandler getStepResultHandler(Integer id) {
            StepResultHandler handler = new StepResultHandler(id, this);
            this.stepResultHandlers.put(id, handler);
            return handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordRollbackOp(Integer id, ModelNode compensatingOperation) {
            this.rollbackOps.put(id, compensatingOperation);
            ModelNode modelNode = this.resultsNode;
            synchronized (modelNode) {
                ModelNode stepResult = this.getStepResultNode(id);
                stepResult.get("compensating-operation").set(compensatingOperation == null ? new ModelNode() : compensatingOperation);
            }
        }

        private void handleSuccess() {
            this.resultHandler.handleResultFragment(ResultHandler.EMPTY_LOCATION, this.resultsNode);
            this.resultHandler.handleResultComplete();
        }

        private ModelNode getOverallFailureDescription() {
            ModelNode failureMsg = new ModelNode();
            String baseMsg = "Composite operation failed and was rolled back. Steps that failed:";
            for (int i = 0; i < this.steps.size(); ++i) {
                ModelNode stepResult = this.getStepResultNode(i);
                if (!stepResult.hasDefined("failure-description")) continue;
                failureMsg.get(new String[]{"Composite operation failed and was rolled back. Steps that failed:", "Operation " + this.getStepKey(i)}).set(stepResult.get("failure-description"));
            }
            return failureMsg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean hasFailures() {
            ModelNode modelNode = this.resultsNode;
            synchronized (modelNode) {
                return this.hasFailures;
            }
        }

        protected void processComplete() {
            if (this.hasFailures()) {
                this.handleFailures();
            } else {
                this.handleSuccess();
            }
        }

        private ModelNode getStepResultNode(Integer id) {
            ModelNode stepResult = this.resultsNode.get(this.getStepKey(id));
            return stepResult;
        }

        @Override
        public ConfigurationPersister getConfigurationPersister() {
            return this.localConfigPersister;
        }

        @Override
        public OperationContext getOperationContext(ModelProvider modelSource, PathAddress address, OperationHandler operationHandler, Operation executionContext) {
            return BasicModelController.this.contextFactory.getOperationContext(modelSource, address, operationHandler, executionContext);
        }

        @Override
        public ModelNode getModel() {
            return this.localModel;
        }
    }

    public static final class XmlMarshallingHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        private final String[] EMPTY = new String[0];
        private final ConfigurationPersister configPersister;
        private final ModelNode model;

        public XmlMarshallingHandler(ConfigurationPersister configPersister, ModelNode model) {
            this.configPersister = configPersister;
            this.model = model;
        }

        @Override
        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getReadConfigAsXmlOperation(locale);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    BufferedOutputStream output = new BufferedOutputStream(baos);
                    this.configPersister.marshallAsXml(this.model, output);
                    output.close();
                    baos.close();
                }
                finally {
                    this.safeClose(baos);
                }
                String xml = new String(baos.toByteArray());
                ModelNode result = new ModelNode().set(xml);
                resultHandler.handleResultFragment(this.EMPTY, result);
            }
            catch (Exception e) {
                e.printStackTrace();
                resultHandler.handleFailed(new ModelNode().set(e.getLocalizedMessage()));
            }
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        private void safeClose(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Throwable t) {
                    log.errorf(t, "Failed to close resource %s", (Object)closeable);
                }
            }
        }
    }
}

