/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.JVMDescriptions;
import org.jboss.as.controller.operations.common.JVMHandlers;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public final class JVMAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final JVMAddHandler INSTANCE = new JVMAddHandler(false);
    public static final JVMAddHandler SERVER_INSTANCE = new JVMAddHandler(true);
    private final boolean server;

    private JVMAddHandler(boolean server) {
        this.server = server;
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
        ModelNode compensatingOperation = Util.getResourceRemoveOperation(operation.require("address"));
        ModelNode subModel = context.getSubModel();
        ModelNode jvmType = subModel.get("type");
        if (operation.hasDefined("type")) {
            jvmType.set(operation.get("type"));
        }
        for (String attr : JVMHandlers.ATTRIBUTES) {
            if (operation.has(attr)) {
                subModel.get(attr).set(operation.get(attr));
                continue;
            }
            subModel.get(attr);
        }
        if (this.server) {
            for (String attr : JVMHandlers.SERVER_ATTRIBUTES) {
                if (operation.has(attr)) {
                    subModel.get(attr).set(operation.get(attr));
                    continue;
                }
                subModel.get(attr);
            }
        }
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOperation);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        if (this.server) {
            return JVMDescriptions.getServerJVMAddDescription(locale);
        }
        return JVMDescriptions.getJVMAddDescription(locale);
    }
}

