/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class SchemaLocationRemoveHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove-schema-location";
    public static final SchemaLocationRemoveHandler INSTANCE = new SchemaLocationRemoveHandler();
    private final ParameterValidator typeValidator = new ModelTypeValidator(ModelType.STRING);

    public static ModelNode getRemoveSchemaLocationOperation(ModelNode address, String schemaURI) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("schema-location").set(schemaURI);
        return op;
    }

    private SchemaLocationRemoveHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode param = operation.get("schema-location");
        this.typeValidator.validateParameter("schema-location", param);
        ModelNode locations = context.getSubModel().get("schema-locations");
        Property toRemove = null;
        ModelNode newList = new ModelNode().setEmptyList();
        String uri = param.asString();
        if (locations.isDefined()) {
            for (Property location : locations.asPropertyList()) {
                if (uri.equals(location.getName())) {
                    toRemove = location;
                    continue;
                }
                newList.add(location.getName(), location.getValue());
            }
        }
        if (toRemove != null) {
            ModelNode compensating = SchemaLocationAddHandler.getAddSchemaLocationOperation(operation.get("address"), toRemove);
            locations.set(newList);
            resultHandler.handleResultComplete();
            return new BasicOperationResult(compensating);
        }
        throw new OperationFailedException(new ModelNode().set("No schema location with URI " + uri + "found"));
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getRemoveSchemaLocationOperation(locale);
    }
}

