/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.SecurityActions;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.dmr.ModelNode;

public class SystemPropertyValueWriteAttributeHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    public static final SystemPropertyValueWriteAttributeHandler INSTANCE = new SystemPropertyValueWriteAttributeHandler();

    private SystemPropertyValueWriteAttributeHandler() {
    }

    @Override
    protected void modelChanged(OperationContext context, ModelNode operation, final ResultHandler resultHandler, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        RuntimeOperationContext runtimeContext = context.getRuntimeContext();
        if (runtimeContext != null) {
            final String propertyName = PathAddress.pathAddress(operation.require("address")).getLastElement().getValue();
            final String propertyValue = newValue.isDefined() ? newValue.asString() : null;
            runtimeContext.setRuntimeTask(new RuntimeTask(){

                @Override
                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    SecurityActions.setSystemProperty(propertyName, propertyValue);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
    }
}

