/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class AttributeDefinition {
    private final String name;
    private final String xmlName;
    private final ModelType type;
    private final boolean allowNull;
    private final boolean allowExpression;
    private final ModelNode defaultValue;
    private final MeasurementUnit measurementUnit;
    private final ParameterValidator validator;

    protected AttributeDefinition(String name, String xmlName, ModelNode defaultValue, ModelType type, boolean allowNull, boolean allowExpression, MeasurementUnit measurementUnit, ParameterValidator validator) {
        this.name = name;
        this.xmlName = xmlName;
        this.type = type;
        this.allowNull = allowNull;
        this.allowExpression = allowExpression;
        this.defaultValue = new ModelNode();
        if (defaultValue != null) {
            this.defaultValue.set(defaultValue);
        }
        this.defaultValue.protect();
        this.measurementUnit = measurementUnit;
        this.validator = validator;
    }

    public String getName() {
        return this.name;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public ModelType getType() {
        return this.type;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public boolean isAllowExpression() {
        return this.allowExpression;
    }

    public ModelNode getDefaultValue() {
        return this.defaultValue.isDefined() ? this.defaultValue : null;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    public ParameterValidator getValidator() {
        return this.validator;
    }

    public boolean isMarshallable(ModelNode resourceModel, boolean marshallDefault) {
        if (resourceModel.hasDefined(this.name)) {
            ModelNode node = resourceModel.get(this.name);
            if (marshallDefault || !node.equals(this.defaultValue)) {
                return true;
            }
        }
        return false;
    }

    public ModelNode validateOperation(ModelNode operationObject) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (operationObject.has(this.name)) {
            node.set(operationObject.get(this.name));
        }
        if (!node.isDefined() && this.defaultValue.isDefined()) {
            node.set(this.defaultValue);
        }
        this.validator.validateParameter(this.name, node);
        return node;
    }

    public void validateAndSet(ModelNode operationObject, ModelNode model) throws OperationFailedException {
        ModelNode node = this.validateOperation(operationObject);
        if (node.isDefined()) {
            model.get(this.name).set(node);
        }
    }

    public ModelNode validateResolvedOperation(ModelNode operationObject) throws OperationFailedException {
        ModelNode node = new ModelNode();
        if (operationObject.has(this.name)) {
            node.set(operationObject.get(this.name));
        }
        if (!node.isDefined() && this.defaultValue.isDefined()) {
            node.set(this.defaultValue);
        }
        this.validator.validateParameter(this.name, node);
        return node.resolve();
    }

    public abstract void marshallAsElement(ModelNode var1, XMLStreamWriter var2) throws XMLStreamException;

    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode attr = new ModelNode();
        attr.get("type").set(attr.getType());
        attr.get("description").set(this.getAttributeTextDescription(bundle, prefix));
        attr.get("nillable").set(this.isAllowNull());
        if (this.defaultValue != null && this.defaultValue.isDefined()) {
            attr.get("default").set(this.defaultValue);
        }
        if (this.measurementUnit != MeasurementUnit.NONE) {
            attr.get("unit").set(this.measurementUnit.getName());
        }
        resourceDescription.get(new String[]{"attributes", this.getName()}).set(attr);
        return attr;
    }

    public ModelNode addOperationParameterDescription(ResourceBundle bundle, String prefix, ModelNode operationDescription) {
        ModelNode param = new ModelNode();
        param.get("type").set(this.type);
        param.get("description").set(this.getAttributeTextDescription(bundle, prefix));
        param.get("required").set(!this.isAllowNull());
        param.get("nillable").set(this.isAllowNull());
        if (this.measurementUnit != MeasurementUnit.NONE) {
            param.get("unit").set(this.measurementUnit.getName());
        }
        operationDescription.get(new String[]{"request-properties", this.getName()}).set(param);
        return param;
    }

    public String getAttributeTextDescription(ResourceBundle bundle, String prefix) {
        String bundleKey = prefix == null ? this.name : prefix + "." + this.name;
        return bundle.getString(bundleKey);
    }
}

