/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public final class CompositeOperationHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final CompositeOperationHandler INSTANCE = new CompositeOperationHandler();
    public static final String NAME = "composite";

    private CompositeOperationHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) {
        int i;
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        List list = operation.get("steps").asList();
        ModelNode responseMap = context.getResult().setEmptyObject();
        HashMap<String, OperationStepHandler> stepHandlerMap = new HashMap<String, OperationStepHandler>();
        int size = list.size();
        for (i = 0; i < size; ++i) {
            String stepName = "step-" + (i + 1);
            responseMap.get(stepName);
            ModelNode subOperation = (ModelNode)list.get(i);
            PathAddress stepAddress = PathAddress.pathAddress(subOperation.get("address"));
            String stepOpName = subOperation.require("operation").asString();
            OperationStepHandler stepHandler = registry.getOperationHandler(stepAddress, stepOpName);
            if (stepHandler == null) {
                context.getFailureDescription().set(String.format("No handler for %s at address %s", stepOpName, stepAddress));
                context.completeStep();
                return;
            }
            stepHandlerMap.put(stepName, stepHandler);
        }
        for (i = size - 1; i >= 0; --i) {
            ModelNode subOperation = (ModelNode)list.get(i);
            String stepName = "step-" + (i + 1);
            context.addStep(responseMap.get(stepName).setEmptyObject(), subOperation, (OperationStepHandler)stepHandlerMap.get(stepName), OperationContext.Stage.IMMEDIATE);
        }
        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
            ModelNode failureMsg = new ModelNode();
            String baseMsg = "Composite operation failed and was rolled back. Steps that failed:";
            for (int i2 = 0; i2 < size; ++i2) {
                String stepName = "step-" + (i2 + 1);
                ModelNode stepResponse = responseMap.get(stepName);
                if (!stepResponse.hasDefined("failure-description")) continue;
                failureMsg.get(new String[]{"Composite operation failed and was rolled back. Steps that failed:", "Operation " + stepName}).set(stepResponse.get("failure-description"));
            }
            if (!failureMsg.isDefined()) {
                failureMsg.set("Composite operation was rolled back");
            }
            context.getFailureDescription().set(failureMsg);
        }
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

