/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class InetAddressMatchInterfaceCriteria
implements InterfaceCriteria {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private static final long serialVersionUID = 149404752878332750L;
    private ModelNode address;
    private InetAddress resolved;
    private boolean unknownHostLogged;
    private boolean anyLocalLogged;

    public InetAddressMatchInterfaceCriteria(ModelNode address) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        this.address = address;
    }

    public synchronized InetAddress getAddress() throws UnknownHostException {
        if (this.resolved == null) {
            this.resolved = InetAddress.getByName(this.address.resolve().asString());
        }
        return this.resolved;
    }

    @Override
    public InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
        try {
            InetAddress toMatch = this.getAddress();
            if (!this.anyLocalLogged && toMatch.isAnyLocalAddress()) {
                log.warnf("Address %1$s is a wildcard address, which will not match against any specific address. Do not use the '%2$s' configuration elementto specify that an interface should use a wildcard address; use '%3$s', '%4$s', or '%5$s'", new Object[]{this.address, "inet-address", "any-address", "any-ipv4-address", "any-ipv6-address"});
                this.anyLocalLogged = true;
            }
            if (this.getAddress().equals(address)) {
                return this.getAddress();
            }
        }
        catch (UnknownHostException e) {
            if (!this.unknownHostLogged) {
                log.warnf("Cannot resolve address %s, so cannot match it to any InetAddress", (Object)this.address);
                this.unknownHostLogged = true;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InetAddressMatchInterfaceCriteria(");
        sb.append("address=");
        sb.append(this.address);
        sb.append(",resolved=");
        sb.append(this.resolved);
        sb.append(')');
        return sb.toString();
    }
}

