/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.as.protocol.old.ProtocolUtils;
import org.jboss.logging.Logger;

public abstract class AbstractModelControllerOperationHandler
implements ManagementOperationHandler {
    final Logger log = Logger.getLogger((String)"org.jboss.as.controller.remote");
    protected final ExecutorService executorService;
    protected final ModelController controller;

    public AbstractModelControllerOperationHandler(ExecutorService executorService, ModelController controller) {
        this.executorService = executorService;
        this.controller = controller;
    }

    public abstract ManagementRequestHandler getRequestHandler(byte var1);

    protected ManagementClientChannelStrategy getChannelStrategy(ManagementChannel channel) {
        return ManagementClientChannelStrategy.create((ManagementChannel)channel);
    }

    private class ProxiedInputStream
    extends InputStream {
        final ManagementChannel channel;
        final int batchId;
        final int index;
        volatile byte[] bytes;
        volatile ByteArrayInputStream delegate;
        volatile Exception error;

        ProxiedInputStream(ManagementChannel channel, int batchId, int index) {
            this.channel = channel;
            this.batchId = batchId;
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            if (this.delegate == null) {
                ProxiedInputStream proxiedInputStream = this;
                synchronized (proxiedInputStream) {
                    if (this.delegate == null) {
                        this.initializeBytes();
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Thread was interrupted waiting to read attachment input stream from remote caller");
                        }
                        if (this.error != null) {
                            if (this.error instanceof IOException) {
                                throw (IOException)this.error;
                            }
                            throw new IOException(this.error);
                        }
                        this.delegate = new ByteArrayInputStream(this.bytes);
                        this.bytes = null;
                    }
                }
            }
            return this.delegate.read();
        }

        void initializeBytes() {
            if (this.bytes == null) {
                new ManagementRequest<Void>(this.batchId){

                    protected byte getRequestCode() {
                        return 76;
                    }

                    protected void writeRequest(int protocolVersion, FlushableDataOutput output) throws IOException {
                        output.write(102);
                        output.writeInt(ProxiedInputStream.this.index);
                    }

                    protected ManagementResponseHandler<Void> getResponseHandler() {
                        return new ManagementResponseHandler<Void>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected Void readResponse(DataInput input) throws IOException {
                                ProxiedInputStream proxiedInputStream = ProxiedInputStream.this;
                                synchronized (proxiedInputStream) {
                                    ProtocolUtils.expectHeader((DataInput)input, (int)103);
                                    int size = input.readInt();
                                    ProtocolUtils.expectHeader((DataInput)input, (int)104);
                                    byte[] buf = new byte[size];
                                    for (int i = 0; i < size; ++i) {
                                        buf[i] = input.readByte();
                                    }
                                    ProxiedInputStream.this.bytes = buf;
                                    ProxiedInputStream.this.notifyAll();
                                }
                                return null;
                            }
                        };
                    }
                }.execute(AbstractModelControllerOperationHandler.this.executorService, AbstractModelControllerOperationHandler.this.getChannelStrategy(this.channel));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown(Exception error) {
            this.error = error;
            ProxiedInputStream proxiedInputStream = this;
            synchronized (proxiedInputStream) {
                this.notifyAll();
            }
        }
    }

    class OperationAttachmentsProxy
    implements OperationAttachments {
        final List<ProxiedInputStream> proxiedStreams;

        OperationAttachmentsProxy(ManagementChannel channel, int batchId, int size) {
            this.proxiedStreams = new ArrayList<ProxiedInputStream>(size);
            for (int i = 0; i < size; ++i) {
                this.proxiedStreams.add(new ProxiedInputStream(channel, batchId, i));
            }
        }

        public List<InputStream> getInputStreams() {
            ArrayList<ProxiedInputStream> result = new ArrayList<ProxiedInputStream>();
            result.addAll(this.proxiedStreams);
            return Collections.unmodifiableList(result);
        }

        void shutdown(Exception error) {
            for (ProxiedInputStream stream : this.proxiedStreams) {
                stream.shutdown(error);
            }
        }
    }

    class OperationMessageHandlerProxy
    implements OperationMessageHandler {
        final ManagementChannel channel;
        final int batchId;

        public OperationMessageHandlerProxy(ManagementChannel channel, int batchId) {
            this.channel = channel;
            this.batchId = batchId;
        }

        public void handleReport(MessageSeverity severity, String message) {
        }
    }
}

