/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ChainedParameterValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.deployment.api.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private static final List<String> CONTENT_ADDITION_PARAMETERS = Arrays.asList("input-stream-index", "bytes", "url");
    private final ContentRepository contentRepository;
    private final boolean isMaster;
    private final ParametersValidator validator = new ParametersValidator();
    private final ParametersValidator unmanagedContentValidator = new ParametersValidator();
    private final ParametersValidator managedContentValidator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address, ModelNode state) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("runtime-name").set(state.get("runtime-name"));
        op.get("content").set(state.get("content"));
        return op;
    }

    public DeploymentAddHandler(ContentRepository contentRepository, boolean isMaster) {
        this.contentRepository = contentRepository;
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        ParametersValidator contentValidator = new ParametersValidator();
        contentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
        contentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1, true));
        contentValidator.registerValidator("relative-to", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        contentValidator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        contentValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.validator.registerValidator("content", ChainedParameterValidator.chain((ParameterValidator[])new ParameterValidator[]{new ListValidator((ParameterValidator)new ParametersOfValidator(contentValidator)), new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                DeploymentAddHandler.validateOnePieceOfContent(value);
            }
        }}));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
        this.unmanagedContentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.unmanagedContentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1));
        this.isMaster = isMaster;
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getAddDeploymentOperation((Locale)locale, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        this.validator.validate(operation);
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        String name = address.getLastElement().getValue();
        String runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
        byte[] hash = null;
        ModelNode content = operation.require("content").clone();
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            this.managedContentValidator.validate(contentItemNode);
            hash = contentItemNode.require("hash").asBytes();
            if (!this.contentRepository.hasContent(hash)) {
                throw DeploymentAddHandler.createFailureException("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash));
            }
        } else if (DeploymentAddHandler.hasValidContentAdditionParameterDefined(contentItemNode)) {
            if (!this.isMaster) {
                throw DeploymentAddHandler.createFailureException("A slave domain controller cannot accept deployment content uploads");
            }
            InputStream in = DeploymentAddHandler.getInputStream(context, contentItemNode);
            try {
                try {
                    hash = this.contentRepository.addContent(in);
                }
                catch (IOException e) {
                    throw DeploymentAddHandler.createFailureException(e.toString());
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)in);
            }
            contentItemNode.get("hash").set(hash);
        } else {
            this.unmanagedContentValidator.validate(contentItemNode);
        }
        ModelNode subModel = context.getSubModel();
        subModel.get("name").set(name);
        subModel.get("runtime-name").set(runtimeName);
        subModel.get("content").set(content);
        resultHandler.handleResultComplete();
        return new BasicOperationResult(Util.getResourceRemoveOperation((ModelNode)operation.get("address")));
    }

    private static InputStream getInputStream(OperationContext context, ModelNode operation) throws OperationFailedException {
        InputStream in = null;
        String message = "";
        if (operation.hasDefined("input-stream-index")) {
            int streamIndex = operation.get("input-stream-index").asInt();
            if (streamIndex > context.getInputStreams().size() - 1) {
                IllegalArgumentException e = new IllegalArgumentException("Invalid input-stream-index=" + streamIndex + ", the maximum index is " + (context.getInputStreams().size() - 1));
                throw DeploymentAddHandler.createFailureException(e, e.getMessage());
            }
            message = "Null stream at index " + streamIndex;
            in = (InputStream)context.getInputStreams().get(streamIndex);
        } else if (operation.hasDefined("bytes")) {
            message = "Invalid byte stream.";
            in = new ByteArrayInputStream(operation.get("bytes").asBytes());
        } else if (operation.hasDefined("url")) {
            String urlSpec = operation.get("url").asString();
            try {
                message = "Invalid url stream.";
                in = new URL(urlSpec).openStream();
            }
            catch (MalformedURLException e) {
                throw DeploymentAddHandler.createFailureException(message);
            }
            catch (IOException e) {
                throw DeploymentAddHandler.createFailureException(message);
            }
        }
        if (in == null) {
            throw DeploymentAddHandler.createFailureException(message);
        }
        return in;
    }

    private static boolean hasValidContentAdditionParameterDefined(ModelNode operation) {
        for (String s : CONTENT_ADDITION_PARAMETERS) {
            if (!operation.hasDefined(s)) continue;
            return true;
        }
        return false;
    }

    private static OperationFailedException createFailureException(String format, Object ... params) {
        return DeploymentAddHandler.createFailureException(String.format(format, params));
    }

    private static OperationFailedException createFailureException(Throwable cause, String format, Object ... params) {
        return DeploymentAddHandler.createFailureException(cause, String.format(format, params));
    }

    private static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }

    private static OperationFailedException createFailureException(Throwable cause, String msg) {
        return new OperationFailedException(cause, new ModelNode().set(msg));
    }

    private static void validateOnePieceOfContent(ModelNode content) throws OperationFailedException {
        if (content.asList().size() != 1) {
            throw DeploymentAddHandler.createFailureException("Only 1 piece of content is current supported (AS7-431");
        }
    }
}

