/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ChainedParameterValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.deployment.api.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class DeploymentFullReplaceHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "full-replace-deployment";
    private final ContentRepository contentRepository;
    private final boolean isMaster;
    private final ParametersValidator validator = new ParametersValidator();
    private final ParametersValidator unmanagedContentValidator = new ParametersValidator();
    private final ParametersValidator managedContentValidator = new ParametersValidator();

    public DeploymentFullReplaceHandler(ContentRepository contentRepository, boolean isMaster) {
        this.contentRepository = contentRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false));
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        ParametersValidator contentValidator = new ParametersValidator();
        contentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
        contentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1, true));
        contentValidator.registerValidator("relative-to", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        contentValidator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        contentValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.validator.registerValidator("content", ChainedParameterValidator.chain((ParameterValidator[])new ParameterValidator[]{new ListValidator((ParameterValidator)new ParametersOfValidator(contentValidator)), new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                AbstractDeploymentHandler.validateOnePieceOfContent(value);
            }
        }}));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
        this.unmanagedContentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.unmanagedContentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1));
        this.isMaster = isMaster;
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getFullReplaceDeploymentOperation((Locale)locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode rootModel;
        ModelNode deployments;
        ModelNode replaceNode;
        byte[] hash;
        this.validator.validate(operation);
        String name = operation.require("name").asString();
        String runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : name;
        ModelNode content = operation.require("content").clone();
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            this.managedContentValidator.validate(contentItemNode);
            hash = contentItemNode.require("hash").asBytes();
            if (!this.contentRepository.hasContent(hash)) {
                throw AbstractDeploymentHandler.createFailureException("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash));
            }
        } else if (AbstractDeploymentHandler.hasValidContentAdditionParameterDefined(contentItemNode)) {
            if (!this.isMaster) {
                throw AbstractDeploymentHandler.createFailureException("A slave domain controller cannot accept deployment content uploads");
            }
            InputStream in = AbstractDeploymentHandler.getInputStream(context, contentItemNode);
            try {
                try {
                    hash = this.contentRepository.addContent(in);
                }
                catch (IOException e) {
                    throw AbstractDeploymentHandler.createFailureException(e.toString());
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)in);
            }
            contentItemNode.get("hash").set(hash);
        } else {
            this.unmanagedContentValidator.validate(contentItemNode);
        }
        ModelNode modelNode = replaceNode = (deployments = (rootModel = context.getSubModel()).get("deployment")).hasDefined(name) ? deployments.get(name) : null;
        if (replaceNode == null) {
            throw AbstractDeploymentHandler.createFailureException("No deployment with name %s found", name);
        }
        ModelNode deployNode = new ModelNode();
        deployNode.get("name").set(name);
        deployNode.get("runtime-name").set(runtimeName);
        deployNode.get("content").set(content);
        deployments.get(name).set(deployNode);
        if (rootModel.hasDefined("server-group")) {
            for (Property server : rootModel.get("server-group").asPropertyList()) {
                ModelNode serverConfig = server.getValue();
                if (!serverConfig.hasDefined("deployment") || !serverConfig.get("deployment").hasDefined(name)) continue;
                ModelNode groupDeployNode = serverConfig.get(new String[]{"deployment", name});
                groupDeployNode.get("runtime-name").set(runtimeName);
            }
        }
        ModelNode compensatingOp = operation.clone();
        compensatingOp.get("runtime-name").set(replaceNode.get("runtime-name").asString());
        compensatingOp.get("content").set(replaceNode.require("content").clone());
        DeploymentFullReplaceHandler.removeContentAdditions(compensatingOp.require("content"));
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }

    private static void removeAttributes(ModelNode node, Iterable<String> attributeNames) {
        for (String attributeName : attributeNames) {
            node.remove(attributeName);
        }
    }

    private static void removeContentAdditions(ModelNode content) {
        for (ModelNode contentItem : content.asList()) {
            DeploymentFullReplaceHandler.removeAttributes(contentItem, AbstractDeploymentHandler.CONTENT_ADDITION_PARAMETERS);
        }
    }
}

