/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.domain.http.server.ManagementHttpHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;

public class ConsoleHandler
implements ManagementHttpHandler {
    public static final String CONTEXT = "/console";
    private ClassLoader loader = null;
    private static Map<String, String> contentTypeMapping = new ConcurrentHashMap<String, String>();

    public ConsoleHandler() {
    }

    public ConsoleHandler(ClassLoader loader) {
        this.loader = loader;
    }

    public void handle(HttpExchange http) throws IOException {
        InputStream inputStream;
        URI uri = http.getRequestURI();
        String requestMethod = http.getRequestMethod();
        if (!"GET".equals(requestMethod)) {
            http.sendResponseHeaders(405, -1L);
            return;
        }
        String path = uri.getPath();
        String resource = path.substring(CONTEXT.length(), path.length());
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        if (resource.equals("")) {
            InetSocketAddress address = http.getHttpContext().getServer().getAddress();
            String hostName = address.getHostName();
            int port = address.getPort();
            Headers responseHeaders = http.getResponseHeaders();
            responseHeaders.add("Content-Type", "text/html");
            responseHeaders.add("Location", "http://" + hostName + ":" + port + "/console/index.html");
            http.sendResponseHeaders(302, 0L);
            OutputStream outputStream = http.getResponseBody();
            outputStream.flush();
            this.safeClose(outputStream);
            return;
        }
        if (resource.indexOf(".") == -1) {
            this.respond404(http);
        }
        if ((inputStream = this.getLoader().getResourceAsStream(resource)) != null) {
            int nextChar;
            Headers responseHeaders = http.getResponseHeaders();
            responseHeaders.add("Content-Type", this.resolveContentType(path));
            responseHeaders.add("Access-Control-Allow-Origin", "*");
            http.sendResponseHeaders(200, 0L);
            OutputStream outputStream = http.getResponseBody();
            while ((nextChar = inputStream.read()) != -1) {
                outputStream.write(nextChar);
            }
            outputStream.flush();
            this.safeClose(outputStream);
            this.safeClose(inputStream);
        } else {
            this.respond404(http);
        }
    }

    private void safeClose(Closeable close) {
        try {
            close.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String resolveContentType(String resource) {
        assert (resource.indexOf(".") != -1) : "Invalid resource";
        String contentType = null;
        for (String suffix : contentTypeMapping.keySet()) {
            if (!resource.endsWith(suffix)) continue;
            contentType = contentTypeMapping.get(suffix);
            break;
        }
        if (null == contentType) {
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    private void respond404(HttpExchange http) throws IOException {
        Headers responseHeaders = http.getResponseHeaders();
        responseHeaders.add("Content-Type", "text/html");
        responseHeaders.add("Access-Control-Allow-Origin", "*");
        http.sendResponseHeaders(404, 0L);
        OutputStream out = http.getResponseBody();
        out.flush();
        this.safeClose(out);
    }

    private ClassLoader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return ConsoleHandler.class.getClassLoader();
    }

    @Override
    public void start(HttpServer httpServer, SecurityRealm securityRealm) {
        httpServer.createContext(CONTEXT, (HttpHandler)this);
    }

    @Override
    public void stop(HttpServer httpServer) {
        httpServer.removeContext(CONTEXT);
    }

    static {
        contentTypeMapping.put(".js", "application/javascript");
        contentTypeMapping.put(".html", "text/html");
        contentTypeMapping.put(".htm", "text/html");
        contentTypeMapping.put(".css", "text/css");
        contentTypeMapping.put(".gif", "image/gif");
        contentTypeMapping.put(".png", "image/png");
        contentTypeMapping.put(".jpeg", "image/jpeg");
    }
}

