/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.http.server.NonceFactory;
import org.jboss.as.domain.management.util.HexUtil;
import org.jboss.com.sun.net.httpserver.Authenticator;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpPrincipal;

class DigestAuthenticator
extends Authenticator {
    private Map<InetSocketAddress, DigestContext> authentications = new HashMap<InetSocketAddress, DigestContext>();
    private final NonceFactory nonceFactory = new NonceFactory();
    private final CallbackHandler callbackHandler;
    private final String realm;
    private static final byte COLON = 58;
    private static final String CHALLENGE = "Digest";
    private static final String NONCE = "nonce";
    private static final String MD5 = "MD5";
    private static final String REALM = "realm";
    private static final String RESPONSE = "response";
    private static final String USERNAME = "username";
    private static final String URI = "uri";

    public DigestAuthenticator(CallbackHandler callbackHandler, String realm) {
        this.callbackHandler = callbackHandler;
        this.realm = realm;
    }

    public Authenticator.Result authenticate(HttpExchange httpExchange) {
        DigestContext context = this.getOrCreateNegotiationContext(httpExchange.getRemoteAddress());
        if (context.isAuthenticated()) {
            return new Authenticator.Success(context.getPrincipal());
        }
        Headers requestHeaders = httpExchange.getRequestHeaders();
        if (!requestHeaders.containsKey((Object)"Authorization")) {
            Headers responseHeaders = httpExchange.getResponseHeaders();
            responseHeaders.add("WWW-Authenticate", "Digest " + this.createChallenge(false));
            return new Authenticator.Retry(401);
        }
        String authorizationHeader = requestHeaders.getFirst("Authorization");
        if (!authorizationHeader.startsWith("Digest ")) {
            throw new RuntimeException("Invalid 'Authorization' header.");
        }
        String challenge = authorizationHeader.substring(CHALLENGE.length() + 1);
        Map<String, String> challengeParameters = this.parseDigestChallenge(challenge);
        HttpPrincipal principal = this.validateUser(challengeParameters);
        if (principal == null) {
            if (challengeParameters.containsKey(NONCE)) {
                this.nonceFactory.useNonce(challengeParameters.get(NONCE));
            }
            return new Authenticator.Failure(403);
        }
        if (this.nonceFactory.useNonce(challengeParameters.get(NONCE))) {
            context.principal = principal;
            return new Authenticator.Success(principal);
        }
        Headers responseHeaders = httpExchange.getResponseHeaders();
        responseHeaders.add("WWW-Authenticate", "Digest " + this.createChallenge(true));
        return new Authenticator.Retry(401);
    }

    private HttpPrincipal validateUser(Map<String, String> challengeParameters) {
        RealmCallback rcb = new RealmCallback("Realm", challengeParameters.get(REALM));
        NameCallback ncb = new NameCallback("Username", challengeParameters.get(USERNAME));
        PasswordCallback pcb = new PasswordCallback("Password", false);
        Callback[] callbacks = new Callback[]{rcb, ncb, pcb};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw new IllegalStateException("CallbackHander not suitable for Digest authentication.");
        }
        catch (UnsupportedCallbackException e) {
            throw new IllegalStateException("CallbackHander not suitable for Digest authentication.");
        }
        try {
            MessageDigest md = MessageDigest.getInstance(MD5);
            md.update(challengeParameters.get(USERNAME).getBytes());
            md.update((byte)58);
            md.update(challengeParameters.get(REALM).getBytes());
            md.update((byte)58);
            md.update(new String(pcb.getPassword()).getBytes());
            byte[] ha1 = HexUtil.convertToHexBytes((byte[])md.digest());
            md.update("GET".getBytes());
            md.update((byte)58);
            md.update(challengeParameters.get(URI).getBytes());
            byte[] ha2 = HexUtil.convertToHexBytes((byte[])md.digest());
            md.update(ha1);
            md.update((byte)58);
            md.update(challengeParameters.get(NONCE).getBytes());
            md.update((byte)58);
            md.update(ha2);
            byte[] expectedResponse = HexUtil.convertToHexBytes((byte[])md.digest());
            byte[] actualResponse = challengeParameters.get(RESPONSE).getBytes();
            if (MessageDigest.isEqual(expectedResponse, actualResponse)) {
                return new HttpPrincipal(challengeParameters.get(USERNAME), challengeParameters.get(REALM));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to perform digest validation as MD5 is unavailable.", e);
        }
        return null;
    }

    private String createChallenge(boolean stale) {
        StringBuilder challenge = new StringBuilder();
        challenge.append("realm=\"").append(this.realm).append("\",");
        challenge.append("nonce=\"").append(this.nonceFactory.createNonce()).append("\"");
        if (stale) {
            challenge.append(",stale=true");
        }
        return challenge.toString();
    }

    private Map<String, String> parseDigestChallenge(String challenge) {
        HashMap<String, String> response = new HashMap<String, String>();
        HeaderParser parser = new HeaderParser(challenge);
        while (parser.hasNext()) {
            HeaderParser.Parameter next = parser.next();
            response.put(next.key, next.value);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DigestContext getOrCreateNegotiationContext(InetSocketAddress remoteAddress) {
        DigestContext context = null;
        Map<InetSocketAddress, DigestContext> map = this.authentications;
        synchronized (map) {
            context = this.authentications.get(remoteAddress);
            if (context == null) {
                context = new DigestContext();
                this.authentications.put(remoteAddress, context);
            }
        }
        return context;
    }

    static boolean requiredCallbacksSupported(Class[] callbacks) {
        if (!DigestAuthenticator.contains(NameCallback.class, callbacks)) {
            return false;
        }
        if (!DigestAuthenticator.contains(RealmCallback.class, callbacks)) {
            return false;
        }
        return DigestAuthenticator.contains(PasswordCallback.class, callbacks);
    }

    private static boolean contains(Class clazz, Class[] classes) {
        for (Class current : classes) {
            if (!current.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private class DigestContext {
        private HttpPrincipal principal = null;

        private DigestContext() {
        }

        boolean isAuthenticated() {
            return this.principal != null;
        }

        HttpPrincipal getPrincipal() {
            return this.principal;
        }
    }

    private class HeaderParser {
        private static final char EQUALS = '=';
        private static final char DELIMITER = ',';
        private static final char QUOTE = '\"';
        private static final char ESCAPE = '\\';
        private final String message;
        private final int length;
        private int pos = 0;
        private boolean hasNextConfirmed;

        HeaderParser(String message) {
            this.message = message;
            this.length = message.length();
        }

        boolean hasNext() {
            if (this.hasNextConfirmed) {
                return true;
            }
            if (this.pos >= this.length) {
                return false;
            }
            int nextEquals = this.message.indexOf(61, this.pos);
            if (nextEquals < 0 || nextEquals >= this.length - 1) {
                return false;
            }
            this.hasNextConfirmed = true;
            return true;
        }

        Parameter next() {
            if (!this.hasNextConfirmed && !this.hasNext()) {
                return null;
            }
            Parameter response = new Parameter();
            int equalsPos = this.message.indexOf(61, this.pos);
            response.key = this.message.substring(this.pos, equalsPos).trim();
            this.pos = equalsPos + 1;
            int nextDelimiter = this.message.indexOf(44, this.pos);
            int nextQuote = this.message.indexOf(34, this.pos);
            boolean quoted = false;
            if (nextQuote > 0 && (nextDelimiter < 0 || nextQuote < nextDelimiter)) {
                quoted = true;
            }
            if (quoted) {
                String dropping = this.message.substring(this.pos, nextQuote).trim();
                if (!"".equals(dropping)) {
                    throw new IllegalArgumentException("Unexpected characters being dropped from header '" + dropping + "' for " + response.key);
                }
                this.pos = nextQuote;
                int endQuote = -1;
                while (endQuote < 0) {
                    if ((nextQuote = this.message.indexOf(34, nextQuote + 1)) < 0) {
                        throw new IllegalArgumentException("Unable to find closing quote for " + response.key);
                    }
                    if (this.message.charAt(nextQuote - 1) == '\\') continue;
                    endQuote = nextQuote;
                }
                response.value = this.message.substring(this.pos + 1, endQuote);
                int nextDelimeter = this.message.indexOf(44, this.pos);
                if (nextDelimeter > 0) {
                    this.pos = nextDelimeter + 1;
                }
            } else {
                int nextDelimeter = this.message.indexOf(44, this.pos);
                if (nextDelimeter > 0) {
                    response.value = this.message.substring(this.pos, nextDelimeter).trim();
                    this.pos = nextDelimeter + 1;
                } else {
                    response.value = this.message.substring(this.pos, this.length - 1).trim();
                    this.pos = this.length + 1;
                }
            }
            this.hasNextConfirmed = false;
            return response;
        }

        class Parameter {
            String key;
            String value;

            Parameter() {
            }
        }
    }
}

