/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import java.util.Arrays;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;
import org.jboss.as.domain.management.security.state.WeakCheckState;

public class PromptPasswordState
implements State {
    private ConsoleWrapper theConsole;
    private StateValues stateValues;

    public PromptPasswordState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (stateValues != null && !stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        WeakCheckState continuingState = new WeakCheckState(this.theConsole, this.stateValues);
        if (!this.stateValues.isSilentOrNonInteractive()) {
            this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordPrompt(), new Object[0]);
            char[] tempChar = this.theConsole.readPassword(" : ", new Object[0]);
            if (tempChar == null || tempChar.length == 0) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.noPasswordExiting());
            }
            this.theConsole.printf(DomainManagementMessages.MESSAGES.passwordConfirmationPrompt(), new Object[0]);
            char[] secondTempChar = this.theConsole.readPassword(" : ", new Object[0]);
            if (secondTempChar == null) {
                secondTempChar = new char[]{};
            }
            if (!Arrays.equals(tempChar, secondTempChar)) {
                return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.passwordMisMatch(), this);
            }
            this.stateValues.setPassword(tempChar);
            if (!this.stateValues.isManagement()) {
                this.theConsole.printf(DomainManagementMessages.MESSAGES.rolesPrompt(), new Object[0]);
                String userRoles = this.stateValues.getKnownRoles().get(this.stateValues.getUserName());
                this.stateValues.setRoles(this.theConsole.readLine("[%1$2s]: ", userRoles == null ? "" : userRoles));
            }
        }
        return continuingState;
    }
}

