/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.AddPropertiesUser;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ConfirmationChoice;
import org.jboss.as.domain.management.security.state.DuplicateUserCheckState;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.PromptNewUserState;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;

public class WeakCheckState
implements State {
    private ConsoleWrapper theConsole;
    private StateValues stateValues;
    private static char[] VALID_PUNCTUATION = new char[]{'.', '@', '\\', '=', ',', '/'};

    public WeakCheckState(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (stateValues != null && !stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    private boolean isValidPunctuation(char currentChar) {
        Arrays.sort(VALID_PUNCTUATION);
        return Arrays.binarySearch(VALID_PUNCTUATION, currentChar) >= 0;
    }

    @Override
    public State execute() {
        PromptNewUserState retryState;
        PromptNewUserState promptNewUserState = retryState = this.stateValues.isSilentOrNonInteractive() ? null : new PromptNewUserState(this.theConsole, this.stateValues);
        if (Arrays.equals(this.stateValues.getUserName().toCharArray(), this.stateValues.getPassword())) {
            return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.usernamePasswordMatch(), retryState);
        }
        for (char currentChar : this.stateValues.getUserName().toCharArray()) {
            if (this.isValidPunctuation(currentChar) || Character.isLetter(currentChar) || Character.isDigit(currentChar)) continue;
            return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.usernameNotAlphaNumeric(), retryState);
        }
        boolean weakUserName = false;
        for (String current : AddPropertiesUser.BAD_USER_NAMES) {
            if (!current.equals(this.stateValues.getUserName().toLowerCase(Locale.ENGLISH))) continue;
            weakUserName = true;
            break;
        }
        DuplicateUserCheckState continuingState = new DuplicateUserCheckState(this.theConsole, this.stateValues);
        if (weakUserName && !this.stateValues.isSilentOrNonInteractive()) {
            String message = DomainManagementMessages.MESSAGES.usernameEasyToGuess(this.stateValues.getUserName());
            String prompt = DomainManagementMessages.MESSAGES.sureToAddUser(this.stateValues.getUserName());
            PromptNewUserState noState = new PromptNewUserState(this.theConsole, this.stateValues);
            return new ConfirmationChoice(this.theConsole, message, prompt, continuingState, noState);
        }
        return continuingState;
    }
}

