/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.AbstractComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentEntry;
import org.jboss.as.ee.component.ComponentInjector;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.PerViewMethodInterceptorFactory;
import org.jboss.as.ee.component.ResourceInjection;
import org.jboss.as.ee.component.SecurityActions;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.InterceptorInstanceFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractComponent
implements Component {
    public static final Object INSTANCE_KEY = new Object();
    public static final Object COMPONENT_INSTANCE_KEY = new Object();
    public static final Object INJECTION_HANDLE_KEY = new Object();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final InterceptorInstanceFactory INSTANCE_FACTORY = new InterceptorInstanceFactory(){

        public Object createInstance(InterceptorFactoryContext context) {
            return context.getContextData().get(INSTANCE_KEY);
        }
    };
    private final String componentName;
    private final Class<?> componentClass;
    private final List<ResourceInjection> resourceInjections;
    private final InterceptorFactory postConstruct;
    private final InterceptorFactory preDestroy;
    private final List<ComponentInjector> componentInjectors;
    private Interceptor componentInterceptor;
    private final Map<Method, InterceptorFactory> interceptorFactoryMap;
    private final InjectedValue<NamespaceContextSelector> namespaceContextSelectorInjector = new InjectedValue();
    private final Map<Class<?>, ServiceName> viewServices;
    private final Map<Class<?>, ComponentView> views = new HashMap();
    @Deprecated
    private final Collection<Method> componentMethods;
    private volatile boolean gate;

    protected AbstractComponent(AbstractComponentConfiguration configuration) {
        this.componentName = configuration.getComponentName();
        this.componentClass = configuration.getComponentClass();
        this.resourceInjections = configuration.getResourceInjections();
        this.interceptorFactoryMap = configuration.getInterceptorFactoryMap();
        this.componentInjectors = configuration.getComponentInjectors();
        this.viewServices = new HashMap(configuration.getViewServices());
        this.componentMethods = configuration.getComponentMethods();
        this.postConstruct = Interceptors.getChainedInterceptorFactory(configuration.getPostConstruct());
        this.preDestroy = Interceptors.getChainedInterceptorFactory(configuration.getPreDestroy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentInstance createInstance() {
        if (!this.gate) {
            AbstractComponent abstractComponent = this;
            synchronized (abstractComponent) {
                while (!this.gate) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException("Component not available (interrupted)");
                    }
                }
            }
        }
        SimpleInterceptorFactoryContext interceptorContext = new SimpleInterceptorFactoryContext();
        Object objectInstance = this.createObjectInstance();
        AbstractComponentInstance instance = this.constructComponentInstance(objectInstance, (InterceptorFactoryContext)interceptorContext);
        List<ComponentInjector.InjectionHandle> injectionHandles = this.applyInjections(instance);
        interceptorContext.getContextData().put(INJECTION_HANDLE_KEY, injectionHandles);
        interceptorContext.getContextData().put(INSTANCE_KEY, objectInstance);
        interceptorContext.getContextData().put(COMPONENT_INSTANCE_KEY, instance);
        this.performLifecycle(instance, this.postConstruct, (InterceptorFactoryContext)interceptorContext);
        Map<Method, InterceptorFactory> factoryMap = this.getInterceptorFactoryMap();
        IdentityHashMap<Method, Interceptor> methodMap = new IdentityHashMap<Method, Interceptor>(factoryMap.size());
        for (Map.Entry<Method, InterceptorFactory> entry : factoryMap.entrySet()) {
            Method method = entry.getKey();
            PerViewMethodInterceptorFactory.populate((InterceptorFactoryContext)interceptorContext, this, instance, method);
            InterceptorFactory interceptorFactory = entry.getValue();
            assert (interceptorFactory != null) : "Can't find interceptor factory for " + method;
            methodMap.put(method, interceptorFactory.create((InterceptorFactoryContext)interceptorContext));
        }
        instance.setMethodMap(methodMap);
        return instance;
    }

    protected Object createObjectInstance() {
        try {
            Object instance = this.componentClass.newInstance();
            return instance;
        }
        catch (InstantiationException e) {
            InstantiationError error = new InstantiationError(e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
    }

    public void destroyInstance(ComponentInstance instance) {
        this.performLifecycle(instance, this.preDestroy, instance.getInterceptorFactoryContext());
        List injectionHandles = (List)instance.getInterceptorFactoryContext().getContextData().get(INJECTION_HANDLE_KEY);
        if (injectionHandles != null) {
            for (ComponentInjector.InjectionHandle handle : injectionHandles) {
                handle.uninject();
            }
        }
    }

    protected abstract AbstractComponentInstance constructComponentInstance(Object var1, InterceptorFactoryContext var2);

    @Override
    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public String getComponentName() {
        return this.componentName;
    }

    protected List<ComponentInjector.InjectionHandle> applyInjections(ComponentInstance componentInstance) {
        List<ResourceInjection> resourceInjections = this.resourceInjections;
        if (resourceInjections != null) {
            for (ResourceInjection resourceInjection : resourceInjections) {
                resourceInjection.inject(componentInstance.getInstance());
            }
        }
        ArrayList<ComponentInjector.InjectionHandle> injectionHandles = new ArrayList<ComponentInjector.InjectionHandle>();
        for (ComponentInjector injector : this.componentInjectors) {
            injectionHandles.add(injector.inject(componentInstance.getInstance()));
        }
        return injectionHandles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLifecycle(ComponentInstance instance, InterceptorFactory lifecycleInterceptors, InterceptorFactoryContext factoryContext) {
        ClassLoader contextCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.componentClass.getClassLoader());
        try {
            Interceptor interceptor = lifecycleInterceptors.create(factoryContext);
            try {
                InterceptorContext context = new InterceptorContext();
                context.setTarget((Object)instance);
                context.setContextData(new HashMap());
                context.setParameters(EMPTY_OBJECT_ARRAY);
                interceptor.processInvocation(context);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to invoke post construct method for class " + this.getComponentClass(), t);
            }
        }
        finally {
            SecurityActions.setContextClassLoader(contextCl);
        }
    }

    public List<ResourceInjection> getResourceInjections() {
        return Collections.unmodifiableList(this.resourceInjections);
    }

    public ComponentEntry createClient(final Class<?> viewClass) {
        ComponentView view = this.views.get(viewClass);
        if (view == null) {
            throw new IllegalArgumentException("Non-existent view " + viewClass + " requested");
        }
        final ManagedReference managedReference = view.getReference();
        Method[] methods = view.getProxyFactory().getCachedMethods();
        final IdentityHashMap<Method, Interceptor> interceptorMap = new IdentityHashMap<Method, Interceptor>();
        SimpleInterceptorFactoryContext interceptorFactoryContext = new SimpleInterceptorFactoryContext();
        for (Method method : methods) {
            InterceptorFactory interceptorFactory = this.interceptorFactoryMap.get(method);
            if (interceptorFactory == null) continue;
            interceptorMap.put(method, interceptorFactory.create((InterceptorFactoryContext)interceptorFactoryContext));
        }
        final Set<Method> allowedMethods = Collections.unmodifiableSet(this.interceptorFactoryMap.keySet());
        return new ComponentEntry(){

            @Override
            public Component getComponent() {
                return AbstractComponent.this;
            }

            @Override
            public Class<?> getViewClass() {
                return viewClass;
            }

            @Override
            public Collection<Method> allowedMethods() {
                return allowedMethods;
            }

            @Override
            public Interceptor getEntryPoint(Method method) throws IllegalArgumentException {
                Interceptor interceptor = (Interceptor)interceptorMap.get(method);
                if (interceptor == null) {
                    throw new IllegalArgumentException("No entry point found for " + method);
                }
                return interceptor;
            }

            @Override
            public boolean isAsynchronous(Method method) throws IllegalArgumentException {
                if (!interceptorMap.containsKey(method)) {
                    throw new IllegalArgumentException("No entry point found for " + method);
                }
                return false;
            }

            @Override
            public void destroy() {
                managedReference.release();
            }
        };
    }

    public NamespaceContextSelector getNamespaceContextSelector() {
        return (NamespaceContextSelector)this.namespaceContextSelectorInjector.getValue();
    }

    InjectedValue<NamespaceContextSelector> getNamespaceContextSelectorInjector() {
        return this.namespaceContextSelectorInjector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        AbstractComponent abstractComponent = this;
        synchronized (abstractComponent) {
            this.gate = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AbstractComponent abstractComponent = this;
        synchronized (abstractComponent) {
            this.gate = false;
        }
    }

    Map<Method, InterceptorFactory> getInterceptorFactoryMap() {
        return this.interceptorFactoryMap;
    }

    public Object createRemoteProxy(Class<?> view, ClassLoader targetClassLoader, Interceptor clientInterceptor) {
        throw new UnsupportedOperationException("One thing at a time!");
    }

    protected Interceptor getComponentInterceptor() {
        assert (this.componentInterceptor != null) : "componentInterceptor is null";
        return this.componentInterceptor;
    }

    void setComponentInterceptor(Interceptor interceptor) {
        this.componentInterceptor = interceptor;
    }

    void addComponentView(ComponentView view) {
        this.views.put(view.getViewClass(), view);
    }

    @Deprecated
    public Method getComponentMethod(Method other) {
        for (Method id : this.componentMethods) {
            if (!other.equals(id)) continue;
            return id;
        }
        throw new IllegalArgumentException("Can't find method " + other);
    }

    public ComponentView getComponentView(Class<?> viewClass) {
        return this.views.get(viewClass);
    }

    public Map<Class<?>, ServiceName> getViewServices() {
        return Collections.unmodifiableMap(this.viewServices);
    }

    void removeComponentView(ComponentView view) {
        this.views.remove(view.getViewClass());
    }
}

