/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayDeque;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;

public abstract class ClassDescriptionTraversal {
    final EEModuleClassConfiguration classConfiguration;
    final EEModuleConfiguration moduleConfiguration;

    ClassDescriptionTraversal(EEModuleClassConfiguration classConfiguration, EEModuleConfiguration moduleConfiguration) {
        this.classConfiguration = classConfiguration;
        this.moduleConfiguration = moduleConfiguration;
    }

    public void run() throws DeploymentUnitProcessingException {
        ArrayDeque<EEModuleClassConfiguration> queue = new ArrayDeque<EEModuleClassConfiguration>();
        for (Class<?> clazz = this.classConfiguration.getModuleClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            EEModuleClassConfiguration configuration = this.moduleConfiguration.getClassConfiguration(clazz.getName());
            if (configuration == null) continue;
            queue.addFirst(configuration);
        }
        for (EEModuleClassConfiguration configuration : queue) {
            this.handle(configuration, configuration.getModuleClassDescription());
        }
    }

    protected abstract void handle(EEModuleClassConfiguration var1, EEModuleClassDescription var2) throws DeploymentUnitProcessingException;
}

