/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.invocation.InterceptorFactory;

public class ComponentConfiguration {
    private final ComponentDescription componentDescription;
    private final EEModuleClassConfiguration moduleClassConfiguration;
    private ComponentCreateServiceFactory componentCreateServiceFactory = ComponentCreateServiceFactory.BASIC;
    private final Deque<InterceptorFactory> postConstructInterceptors = new ArrayDeque<InterceptorFactory>();
    private final Deque<InterceptorFactory> preDestroyInterceptors = new ArrayDeque<InterceptorFactory>();
    private final Map<Method, Deque<InterceptorFactory>> componentInterceptors = new IdentityHashMap<Method, Deque<InterceptorFactory>>();
    private ManagedReferenceFactory instanceFactory;
    private final List<DependencyConfigurator> createDependencies = new ArrayList<DependencyConfigurator>();
    private final List<DependencyConfigurator> startDependencies = new ArrayList<DependencyConfigurator>();
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final List<ViewConfiguration> views = new ArrayList<ViewConfiguration>();

    public ComponentConfiguration(ComponentDescription componentDescription, EEModuleClassConfiguration moduleClassConfiguration) {
        this.componentDescription = componentDescription;
        this.moduleClassConfiguration = moduleClassConfiguration;
    }

    public ComponentDescription getComponentDescription() {
        return this.componentDescription;
    }

    public Class<?> getComponentClass() {
        return this.moduleClassConfiguration.getModuleClass();
    }

    public String getComponentName() {
        return this.componentDescription.getComponentName();
    }

    public Set<Method> getDefinedComponentMethods() {
        return this.componentInterceptors.keySet();
    }

    public Deque<InterceptorFactory> getComponentInterceptorDeque(Method method) {
        Map<Method, Deque<InterceptorFactory>> map = this.componentInterceptors;
        Deque<InterceptorFactory> deque = map.get(method);
        if (deque == null) {
            deque = new ArrayDeque<InterceptorFactory>();
            map.put(method, deque);
        }
        return deque;
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    public List<DependencyConfigurator> getCreateDependencies() {
        return this.createDependencies;
    }

    public List<DependencyConfigurator> getStartDependencies() {
        return this.startDependencies;
    }

    public List<ViewConfiguration> getViews() {
        return this.views;
    }

    public Deque<InterceptorFactory> getPostConstructInterceptors() {
        return this.postConstructInterceptors;
    }

    public Deque<InterceptorFactory> getPreDestroyInterceptors() {
        return this.preDestroyInterceptors;
    }

    public String getApplicationName() {
        return this.componentDescription.getApplicationName();
    }

    public String getModuleName() {
        return this.componentDescription.getModuleName();
    }

    public ManagedReferenceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    public void setInstanceFactory(ManagedReferenceFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    public EEModuleClassConfiguration getModuleClassConfiguration() {
        return this.moduleClassConfiguration;
    }

    public ComponentCreateServiceFactory getComponentCreateServiceFactory() {
        return this.componentCreateServiceFactory;
    }

    public void setComponentCreateServiceFactory(ComponentCreateServiceFactory componentCreateServiceFactory) {
        if (componentCreateServiceFactory == null) {
            throw new IllegalArgumentException("componentCreateServiceFactory is null");
        }
        this.componentCreateServiceFactory = componentCreateServiceFactory;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.componentDescription.getComponentName() + " class=" + this.componentDescription.getComponentClassName() + "]";
    }
}

