/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.ManagedReferenceInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceLifecycleMethodInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceMethodInterceptorFactory;
import org.jboss.as.ee.component.ManagedReferenceReleaseInterceptorFactory;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.component.TCCLInterceptor;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ConstructedValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class ComponentDescription {
    private static final DefaultFirstConfigurator FIRST_CONFIGURATOR = new DefaultFirstConfigurator();
    private static final AtomicInteger PROXY_ID = new AtomicInteger(0);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final ServiceName serviceName;
    private final String componentName;
    private final String componentClassName;
    private final EEModuleDescription moduleDescription;
    private final EEModuleClassDescription classDescription;
    private final List<InterceptorDescription> classInterceptors = new ArrayList<InterceptorDescription>();
    private final Set<String> classInterceptorsSet = new HashSet<String>();
    private final Map<MethodIdentifier, List<InterceptorDescription>> methodInterceptors = new HashMap<MethodIdentifier, List<InterceptorDescription>>();
    private final Map<MethodIdentifier, Set<String>> methodInterceptorsSet = new HashMap<MethodIdentifier, Set<String>>();
    private final Set<MethodIdentifier> methodExcludeDefaultInterceptors = new HashSet<MethodIdentifier>();
    private final Set<MethodIdentifier> methodExcludeClassInterceptors = new HashSet<MethodIdentifier>();
    private final Map<String, InterceptorDescription> allInterceptors = new HashMap<String, InterceptorDescription>();
    private final Map<ServiceName, ServiceBuilder.DependencyType> dependencies = new HashMap<ServiceName, ServiceBuilder.DependencyType>();
    private ComponentNamingMode namingMode = ComponentNamingMode.USE_MODULE;
    private boolean excludeDefaultInterceptors = false;
    private DeploymentDescriptorEnvironment deploymentDescriptorEnvironment;
    private final List<ViewDescription> views = new ArrayList<ViewDescription>();
    private final Deque<ComponentConfigurator> configurators = new ArrayDeque<ComponentConfigurator>();

    public ComponentDescription(String componentName, String componentClassName, EEModuleDescription moduleDescription, EEModuleClassDescription classDescription, ServiceName deploymentUnitServiceName) {
        this.moduleDescription = moduleDescription;
        this.classDescription = classDescription;
        if (componentName == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (componentClassName == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (moduleDescription == null) {
            throw new IllegalArgumentException("moduleName is null");
        }
        if (classDescription == null) {
            throw new IllegalArgumentException("classDescription is null");
        }
        if (deploymentUnitServiceName == null) {
            throw new IllegalArgumentException("deploymentUnitServiceName is null");
        }
        this.serviceName = deploymentUnitServiceName.append(new String[]{"component"}).append(new String[]{componentName});
        this.componentName = componentName;
        this.componentClassName = componentClassName;
        this.configurators.addLast(FIRST_CONFIGURATOR);
    }

    public ComponentConfiguration createConfiguration(EEModuleConfiguration moduleConfiguration) {
        return new ComponentConfiguration(this, moduleConfiguration.getClassConfiguration(this.getComponentClassName()));
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public String getModuleName() {
        return this.moduleDescription.getModuleName();
    }

    public String getApplicationName() {
        return this.moduleDescription.getApplicationName();
    }

    public List<InterceptorDescription> getClassInterceptors() {
        return this.classInterceptors;
    }

    public Map<String, InterceptorDescription> getAllInterceptors() {
        return this.allInterceptors;
    }

    public boolean isExcludeDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors) {
        this.excludeDefaultInterceptors = excludeDefaultInterceptors;
    }

    public void excludeDefaultInterceptors(MethodIdentifier method) {
        this.methodExcludeDefaultInterceptors.add(method);
    }

    public boolean isExcludeDefaultInterceptors(MethodIdentifier method) {
        return this.methodExcludeDefaultInterceptors.contains(method);
    }

    public void excludeClassInterceptors(MethodIdentifier method) {
        this.methodExcludeClassInterceptors.add(method);
    }

    public boolean isExcludeClassInterceptors(MethodIdentifier method) {
        return this.methodExcludeClassInterceptors.contains(method);
    }

    public boolean addClassInterceptor(InterceptorDescription description) {
        String name = description.getInterceptorClassName();
        this.moduleDescription.getOrAddClassByName(name);
        if (this.classInterceptorsSet.contains(name)) {
            return false;
        }
        if (!this.allInterceptors.containsKey(name)) {
            this.allInterceptors.put(name, description);
        }
        this.classInterceptors.add(description);
        this.classInterceptorsSet.add(name);
        return true;
    }

    public InterceptorDescription getClassInterceptor(String interceptorClassName) {
        if (!this.classInterceptorsSet.contains(interceptorClassName)) {
            return null;
        }
        for (InterceptorDescription interceptor : this.classInterceptors) {
            if (!interceptor.getInterceptorClassName().equals(interceptorClassName)) continue;
            return interceptor;
        }
        return null;
    }

    public Map<MethodIdentifier, List<InterceptorDescription>> getMethodInterceptors() {
        return this.methodInterceptors;
    }

    public boolean addMethodInterceptor(MethodIdentifier method, InterceptorDescription description) {
        List<InterceptorDescription> interceptors = this.methodInterceptors.get(method);
        Set<String> interceptorClasses = this.methodInterceptorsSet.get(method);
        if (interceptors == null) {
            interceptors = new ArrayList<InterceptorDescription>();
            this.methodInterceptors.put(method, interceptors);
            interceptorClasses = new HashSet<String>();
            this.methodInterceptorsSet.put(method, interceptorClasses);
        }
        String name = description.getInterceptorClassName();
        this.moduleDescription.getOrAddClassByName(name);
        if (interceptorClasses.contains(name)) {
            return false;
        }
        if (!this.allInterceptors.containsKey(name)) {
            this.allInterceptors.put(name, description);
        }
        interceptors.add(description);
        interceptorClasses.add(name);
        return true;
    }

    public ComponentNamingMode getNamingMode() {
        return this.namingMode;
    }

    public void setNamingMode(ComponentNamingMode namingMode) {
        if (namingMode == null) {
            throw new IllegalArgumentException("namingMode is null");
        }
        this.namingMode = namingMode;
    }

    public EEModuleDescription getModuleDescription() {
        return this.moduleDescription;
    }

    public EEModuleClassDescription getClassDescription() {
        return this.classDescription;
    }

    public void addDependency(ServiceName serviceName, ServiceBuilder.DependencyType type) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        Map<ServiceName, ServiceBuilder.DependencyType> dependencies = this.dependencies;
        ServiceBuilder.DependencyType dependencyType = dependencies.get(serviceName);
        if (dependencyType == ServiceBuilder.DependencyType.REQUIRED) {
            dependencies.put(serviceName, ServiceBuilder.DependencyType.REQUIRED);
        } else {
            dependencies.put(serviceName, type);
        }
    }

    public Map<ServiceName, ServiceBuilder.DependencyType> getDependencies() {
        return this.dependencies;
    }

    public DeploymentDescriptorEnvironment getDeploymentDescriptorEnvironment() {
        return this.deploymentDescriptorEnvironment;
    }

    public void setDeploymentDescriptorEnvironment(DeploymentDescriptorEnvironment deploymentDescriptorEnvironment) {
        this.deploymentDescriptorEnvironment = deploymentDescriptorEnvironment;
    }

    public List<ViewDescription> getViews() {
        return this.views;
    }

    public Deque<ComponentConfigurator> getConfigurators() {
        return this.configurators;
    }

    static class InjectedConfigurator
    implements DependencyConfigurator {
        private final ResourceInjectionConfiguration injectionConfiguration;
        private final ComponentConfiguration configuration;
        private final DeploymentPhaseContext context;
        private final InjectedValue<ManagedReferenceFactory> managedReferenceFactoryValue;

        InjectedConfigurator(ResourceInjectionConfiguration injectionConfiguration, ComponentConfiguration configuration, DeploymentPhaseContext context, InjectedValue<ManagedReferenceFactory> managedReferenceFactoryValue) {
            this.injectionConfiguration = injectionConfiguration;
            this.configuration = configuration;
            this.context = context;
            this.managedReferenceFactoryValue = managedReferenceFactoryValue;
        }

        @Override
        public void configureDependency(ServiceBuilder<?> serviceBuilder) throws DeploymentUnitProcessingException {
            InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(this.configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.USE_MODULE, this.configuration.getComponentName(), this.configuration.getModuleName(), this.configuration.getApplicationName());
            this.injectionConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, this.context, (Injector<ManagedReferenceFactory>)this.managedReferenceFactoryValue);
        }
    }

    private static class DefaultFirstConfigurator
    implements ComponentConfigurator {
        private DefaultFirstConfigurator() {
        }

        @Override
        public void configure(final DeploymentPhaseContext context, ComponentDescription description, final ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            final DeploymentUnit deploymentUnit = context.getDeploymentUnit();
            final DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
            final Object instanceKey = BasicComponentInstance.INSTANCE_KEY;
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            EEModuleClassConfiguration componentClassConfiguration = configuration.getModuleClassConfiguration();
            EEModuleConfiguration moduleConfiguration = componentClassConfiguration.getModuleConfiguration();
            ArrayDeque<ManagedReferenceInterceptorFactory> instantiators = new ArrayDeque<ManagedReferenceInterceptorFactory>();
            final ArrayDeque injectors = new ArrayDeque();
            final ArrayDeque uninjectors = new ArrayDeque();
            ArrayDeque<ManagedReferenceReleaseInterceptorFactory> destructors = new ArrayDeque<ManagedReferenceReleaseInterceptorFactory>();
            final ClassReflectionIndex componentClassIndex = deploymentReflectionIndex.getClassIndex(componentClassConfiguration.getModuleClass());
            final ArrayList componentUserAroundInvoke = new ArrayList();
            final HashMap userAroundInvokesByInterceptorClass = new HashMap();
            final HashMap userPostConstructByInterceptorClass = new HashMap();
            final HashMap userPreDestroyByInterceptorClass = new HashMap();
            ManagedReferenceFactory instanceFactory = configuration.getInstanceFactory();
            if (instanceFactory != null) {
                instantiators.addFirst(new ManagedReferenceInterceptorFactory(instanceFactory, instanceKey));
            } else {
                ValueManagedReferenceFactory factory = new ValueManagedReferenceFactory((Value)new ConstructedValue(componentClassIndex.getConstructor(EMPTY_CLASS_ARRAY), Collections.emptyList()));
                instantiators.addFirst(new ManagedReferenceInterceptorFactory((ManagedReferenceFactory)factory, instanceKey));
            }
            destructors.addLast(new ManagedReferenceReleaseInterceptorFactory(instanceKey));
            new ClassDescriptionTraversal(componentClassConfiguration, moduleConfiguration){

                @Override
                public void handle(EEModuleClassConfiguration classConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    for (ResourceInjectionConfiguration injectionConfiguration : classConfiguration.getInjectionConfigurations()) {
                        Object valueContextKey = new Object();
                        InjectedValue managedReferenceFactoryValue = new InjectedValue();
                        configuration.getStartDependencies().add(new InjectedConfigurator(injectionConfiguration, configuration, context, (InjectedValue<ManagedReferenceFactory>)managedReferenceFactoryValue));
                        injectors.addFirst(injectionConfiguration.getTarget().createInjectionInterceptorFactory(instanceKey, valueContextKey, (Value<ManagedReferenceFactory>)managedReferenceFactoryValue, deploymentUnit));
                        uninjectors.addLast(new ManagedReferenceReleaseInterceptorFactory(valueContextKey));
                    }
                }
            }.run();
            ArrayList<InterceptorDescription> interceptors = new ArrayList<InterceptorDescription>();
            interceptors.addAll(description.getAllInterceptors().values());
            for (InterceptorDescription interceptorDescription : interceptors) {
                final String interceptorClassName = interceptorDescription.getInterceptorClassName();
                EEModuleClassConfiguration interceptorConfiguration = moduleConfiguration.getClassConfiguration(interceptorClassName);
                final Class<?> contextKey = interceptorConfiguration.getModuleClass();
                if (interceptorConfiguration.getInstantiator() == null) {
                    throw new DeploymentUnitProcessingException("No default constructor for interceptor class " + interceptorClassName + " on component " + componentClassConfiguration.getModuleClass());
                }
                instantiators.addFirst(new ManagedReferenceInterceptorFactory(interceptorConfiguration.getInstantiator(), contextKey));
                destructors.addLast(new ManagedReferenceReleaseInterceptorFactory(contextKey));
                final boolean isClassLevelInterceptor = description.getClassInterceptors().contains(interceptorDescription);
                new ClassDescriptionTraversal(interceptorConfiguration, moduleConfiguration){

                    @Override
                    public void handle(EEModuleClassConfiguration interceptorClassConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                        MethodIdentifier aroundInvokeMethodIdentifier;
                        Method method;
                        ClassReflectionIndex interceptorClassIndex = deploymentReflectionIndex.getClassIndex(interceptorClassConfiguration.getModuleClass());
                        for (ResourceInjectionConfiguration injectionConfiguration : interceptorClassConfiguration.getInjectionConfigurations()) {
                            Object valueContextKey = new Object();
                            InjectedValue managedReferenceFactoryValue = new InjectedValue();
                            configuration.getStartDependencies().add(new InjectedConfigurator(injectionConfiguration, configuration, context, (InjectedValue<ManagedReferenceFactory>)managedReferenceFactoryValue));
                            injectors.addFirst(injectionConfiguration.getTarget().createInjectionInterceptorFactory(contextKey, valueContextKey, (Value<ManagedReferenceFactory>)managedReferenceFactoryValue, deploymentUnit));
                            uninjectors.addLast(new ManagedReferenceReleaseInterceptorFactory(valueContextKey));
                        }
                        if (isClassLevelInterceptor) {
                            MethodIdentifier preDestroyMethodIdentifier;
                            MethodIdentifier postConstructMethodIdentifier = classDescription.getPostConstructMethod();
                            if (postConstructMethodIdentifier != null) {
                                method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)interceptorClassIndex, (MethodIdentifier)postConstructMethodIdentifier);
                                ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(contextKey, method, true);
                                ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory> userPostConstruct = (ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>)userPostConstructByInterceptorClass.get(interceptorClassName);
                                if (userPostConstruct == null) {
                                    userPostConstruct = new ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>();
                                    userPostConstructByInterceptorClass.put(interceptorClassName, userPostConstruct);
                                }
                                userPostConstruct.add(interceptorFactory);
                            }
                            if ((preDestroyMethodIdentifier = classDescription.getPreDestroyMethod()) != null) {
                                Method method2 = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)interceptorClassIndex, (MethodIdentifier)preDestroyMethodIdentifier);
                                ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(contextKey, method2, true);
                                ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory> userPreDestroy = (ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>)userPreDestroyByInterceptorClass.get(interceptorClassName);
                                if (userPreDestroy == null) {
                                    userPreDestroy = new ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>();
                                    userPreDestroyByInterceptorClass.put(interceptorClassName, userPreDestroy);
                                }
                                userPreDestroy.add(interceptorFactory);
                            }
                        }
                        if ((aroundInvokeMethodIdentifier = classDescription.getAroundInvokeMethod()) != null) {
                            method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)interceptorClassIndex, (MethodIdentifier)aroundInvokeMethodIdentifier);
                            ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory> interceptors = (ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                            if (interceptors == null) {
                                interceptors = new ArrayList<ManagedReferenceLifecycleMethodInterceptorFactory>();
                                userAroundInvokesByInterceptorClass.put(interceptorClassName, interceptors);
                            }
                            interceptors.add(new ManagedReferenceLifecycleMethodInterceptorFactory(contextKey, method, false));
                        }
                    }
                }.run();
            }
            final ArrayDeque userPostConstruct = new ArrayDeque();
            final ArrayDeque userPreDestroy = new ArrayDeque();
            for (InterceptorDescription interceptorClass : description.getClassInterceptors()) {
                if (userPostConstructByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) {
                    userPostConstruct.addAll((Collection)userPostConstructByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
                }
                if (!userPreDestroyByInterceptorClass.containsKey(interceptorClass.getInterceptorClassName())) continue;
                userPreDestroy.addAll((Collection)userPreDestroyByInterceptorClass.get(interceptorClass.getInterceptorClassName()));
            }
            new ClassDescriptionTraversal(componentClassConfiguration, moduleConfiguration){

                @Override
                public void handle(EEModuleClassConfiguration configuration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    MethodIdentifier componentAroundInvokeMethodIdentifier;
                    MethodIdentifier componentPreDestroyMethodIdentifier;
                    MethodIdentifier componentPostConstructMethodIdentifier = classDescription.getPostConstructMethod();
                    if (componentPostConstructMethodIdentifier != null) {
                        Method method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)componentClassIndex, (MethodIdentifier)componentPostConstructMethodIdentifier);
                        ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(instanceKey, method, true);
                        userPostConstruct.addLast(interceptorFactory);
                    }
                    if ((componentPreDestroyMethodIdentifier = classDescription.getPreDestroyMethod()) != null) {
                        Method method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)componentClassIndex, (MethodIdentifier)componentPreDestroyMethodIdentifier);
                        ManagedReferenceLifecycleMethodInterceptorFactory interceptorFactory = new ManagedReferenceLifecycleMethodInterceptorFactory(instanceKey, method, true);
                        userPreDestroy.addLast(interceptorFactory);
                    }
                    if ((componentAroundInvokeMethodIdentifier = classDescription.getAroundInvokeMethod()) != null) {
                        Method method = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, (ClassReflectionIndex)componentClassIndex, (MethodIdentifier)componentAroundInvokeMethodIdentifier);
                        componentUserAroundInvoke.add(new ManagedReferenceLifecycleMethodInterceptorFactory(instanceKey, method, false));
                    }
                }
            }.run();
            ImmediateInterceptorFactory tcclInterceptor = new ImmediateInterceptorFactory((Interceptor)new TCCLInterceptor((ClassLoader)module.getClassLoader()));
            Deque<InterceptorFactory> postConstructInterceptors = configuration.getPostConstructInterceptors();
            Iterator injectorIterator = injectors.descendingIterator();
            while (injectorIterator.hasNext()) {
                postConstructInterceptors.addFirst((InterceptorFactory)injectorIterator.next());
            }
            Iterator instantiatorIterator = instantiators.descendingIterator();
            while (instantiatorIterator.hasNext()) {
                postConstructInterceptors.addFirst((InterceptorFactory)instantiatorIterator.next());
            }
            postConstructInterceptors.addAll(userPostConstruct);
            postConstructInterceptors.add(Interceptors.getTerminalInterceptorFactory());
            postConstructInterceptors.addFirst((InterceptorFactory)tcclInterceptor);
            Deque<InterceptorFactory> preDestroyInterceptors = configuration.getPreDestroyInterceptors();
            Iterator uninjectorsIterator = uninjectors.descendingIterator();
            while (uninjectorsIterator.hasNext()) {
                preDestroyInterceptors.addFirst((InterceptorFactory)uninjectorsIterator.next());
            }
            Iterator destructorIterator = destructors.descendingIterator();
            while (destructorIterator.hasNext()) {
                preDestroyInterceptors.addFirst((InterceptorFactory)destructorIterator.next());
            }
            preDestroyInterceptors.addAll(userPreDestroy);
            preDestroyInterceptors.add(Interceptors.getTerminalInterceptorFactory());
            preDestroyInterceptors.addFirst((InterceptorFactory)tcclInterceptor);
            List<InterceptorDescription> classInterceptors = description.getClassInterceptors();
            Map<MethodIdentifier, List<InterceptorDescription>> methodInterceptors = description.getMethodInterceptors();
            for (Class<?> clazz = componentClassConfiguration.getModuleClass(); clazz != null; clazz = clazz.getSuperclass()) {
                ClassReflectionIndex classIndex = deploymentReflectionIndex.getClassIndex(clazz);
                for (Method method : classIndex.getMethods()) {
                    List<InterceptorDescription> methodLevelInterceptors;
                    MethodIdentifier identifier = MethodIdentifier.getIdentifier(method.getReturnType(), (String)method.getName(), (Class[])method.getParameterTypes());
                    Deque<InterceptorFactory> interceptorDeque = configuration.getComponentInterceptorDeque(method);
                    if (description.isExcludeDefaultInterceptors() || !description.isExcludeDefaultInterceptors(identifier)) {
                        // empty if block
                    }
                    if (!description.isExcludeClassInterceptors(identifier)) {
                        for (InterceptorDescription interceptorDescription : classInterceptors) {
                            String interceptorClassName = interceptorDescription.getInterceptorClassName();
                            List aroundInvokes = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                            if (aroundInvokes == null) continue;
                            interceptorDeque.addAll(aroundInvokes);
                        }
                    }
                    if ((methodLevelInterceptors = methodInterceptors.get(identifier)) != null) {
                        for (InterceptorDescription methodLevelInterceptor : methodLevelInterceptors) {
                            String interceptorClassName = methodLevelInterceptor.getInterceptorClassName();
                            List aroundInvokes = (List)userAroundInvokesByInterceptorClass.get(interceptorClassName);
                            if (aroundInvokes == null) continue;
                            interceptorDeque.addAll(aroundInvokes);
                        }
                    }
                    if (componentUserAroundInvoke == null) continue;
                    interceptorDeque.addAll(componentUserAroundInvoke);
                }
            }
            for (Method method : configuration.getDefinedComponentMethods()) {
                configuration.getComponentInterceptorDeque(method).addFirst(Interceptors.getInitialInterceptorFactory());
                configuration.getComponentInterceptorDeque(method).addLast(new ManagedReferenceMethodInterceptorFactory(instanceKey, method));
                configuration.getComponentInterceptorDeque(method).addFirst((InterceptorFactory)tcclInterceptor);
            }
            for (ViewDescription view : description.getViews()) {
                Class viewClass;
                try {
                    viewClass = module.getClassLoader().loadClass(view.getViewClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load view class " + view.getViewClassName() + " for component " + configuration, (Throwable)e);
                }
                ViewConfiguration viewConfiguration = viewClass.isInterface() ? new ViewConfiguration(viewClass, configuration, view.getServiceName(), new ProxyFactory(viewClass.getName() + "$$$view" + PROXY_ID.incrementAndGet(), Object.class, viewClass.getClassLoader(), new Class[]{viewClass})) : new ViewConfiguration(viewClass, configuration, view.getServiceName(), new ProxyFactory(viewClass.getName() + "$$$view" + PROXY_ID.incrementAndGet(), viewClass, viewClass.getClassLoader(), new Class[0]));
                for (ViewConfigurator configurator : view.getConfigurators()) {
                    configurator.configure(context, configuration, view, viewConfiguration);
                }
                configuration.getViews().add(viewConfiguration);
            }
        }
    }
}

