/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Iterator;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewManagedReferenceFactory;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;

public final class ComponentTypeInjectionSource
extends InjectionSource {
    private final String typeName;

    public ComponentTypeInjectionSource(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        Set<ViewDescription> componentsForViewName = applicationDescription.getComponentsForViewName(this.typeName);
        Iterator<ViewDescription> iterator = componentsForViewName.iterator();
        if (!iterator.hasNext()) {
            throw new DeploymentUnitProcessingException("No component found for type '" + this.typeName + "'");
        }
        ViewDescription description = iterator.next();
        if (iterator.hasNext()) {
            throw new DeploymentUnitProcessingException("Multiple components found for type '" + this.typeName + "'");
        }
        serviceBuilder.addDependency(description.getServiceName(), ComponentView.class, (Injector)new ViewManagedReferenceFactory.Injector(injector));
    }

    @Override
    public boolean equals(Object injectionSource) {
        return injectionSource instanceof ComponentTypeInjectionSource && this.equals((ComponentTypeInjectionSource)injectionSource);
    }

    private boolean equals(ComponentTypeInjectionSource configuration) {
        return configuration != null && this.typeName.equals(configuration.typeName);
    }

    @Override
    public int hashCode() {
        return this.typeName.hashCode();
    }
}

