/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.vfs.VirtualFile;

public class EEApplicationDescription {
    private final Map<String, Set<ViewInformation>> componentsByViewName = new HashMap<String, Set<ViewInformation>>();

    public void addComponent(ComponentDescription description, VirtualFile deploymentRoot) {
        for (ViewDescription viewDescription : description.getViews()) {
            Set<ViewInformation> viewComponents = this.componentsByViewName.get(viewDescription.getViewClassName());
            if (viewComponents == null) {
                viewComponents = new HashSet<ViewInformation>();
                this.componentsByViewName.put(viewDescription.getViewClassName(), viewComponents);
            }
            viewComponents.add(new ViewInformation(viewDescription, deploymentRoot, description.getComponentName()));
        }
    }

    public Set<ViewDescription> getComponentsForViewName(String name) {
        Set<ViewInformation> info = this.componentsByViewName.get(name);
        if (info == null) {
            return Collections.emptySet();
        }
        HashSet<ViewDescription> ret = new HashSet<ViewDescription>();
        for (ViewInformation i : info) {
            ret.add(i.viewDescription);
        }
        return ret;
    }

    public Set<ViewDescription> getComponents(String componentName, String viewName, VirtualFile deploymentRoot) {
        Set<ViewInformation> info = this.componentsByViewName.get(viewName);
        if (info == null) {
            return Collections.emptySet();
        }
        if (componentName.contains("#")) {
            String[] parts = componentName.split("#");
            String path = parts[0];
            VirtualFile virtualPath = deploymentRoot.getChild(path);
            String name = parts[1];
            HashSet<ViewDescription> ret = new HashSet<ViewDescription>();
            for (ViewInformation i : info) {
                if (!i.beanName.equals(name) || !virtualPath.equals(i.deploymentRoot)) continue;
                ret.add(i.viewDescription);
            }
            return ret;
        }
        HashSet<ViewDescription> ret = new HashSet<ViewDescription>();
        for (ViewInformation i : info) {
            if (!i.beanName.equals(componentName)) continue;
            ret.add(i.viewDescription);
        }
        return ret;
    }

    private static class ViewInformation {
        private final ViewDescription viewDescription;
        private final VirtualFile deploymentRoot;
        private final String beanName;

        public ViewInformation(ViewDescription viewDescription, VirtualFile deploymentRoot, String beanName) {
            this.viewDescription = viewDescription;
            this.deploymentRoot = deploymentRoot;
            this.beanName = beanName;
        }
    }
}

