/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfigurator;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;

public final class EEModuleDescription {
    private final String applicationName;
    private volatile String moduleName;
    private final Map<String, ComponentDescription> componentsByName = new HashMap<String, ComponentDescription>();
    private final Map<String, ComponentDescription> componentsByClassName = new HashMap<String, ComponentDescription>();
    private final Map<String, EEModuleClassDescription> classesByName = new HashMap<String, EEModuleClassDescription>();
    private InjectedEENamespaceContextSelector namespaceContextSelector;
    private final Deque<EEModuleConfigurator> moduleConfigurators = new ArrayDeque<EEModuleConfigurator>();

    public EEModuleDescription(String applicationName, String moduleName) {
        this.applicationName = applicationName;
        this.moduleName = moduleName;
    }

    public void addComponent(ComponentDescription description) {
        String componentName = description.getComponentName();
        String componentClassName = description.getComponentClassName();
        if (componentName == null) {
            throw new IllegalArgumentException("componentName is null");
        }
        if (componentClassName == null) {
            throw new IllegalArgumentException("componentClassName is null");
        }
        if (this.componentsByName.containsKey(componentName)) {
            throw new IllegalArgumentException("A component named '" + componentName + "' is already defined in this module");
        }
        if (this.componentsByClassName.containsKey(componentClassName)) {
            throw new IllegalArgumentException("A component of class " + componentClassName + " is already defined in this module");
        }
        this.componentsByName.put(componentName, description);
        this.componentsByClassName.put(componentClassName, description);
    }

    public void addClass(EEModuleClassDescription description) {
        String className = description.getClassName();
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (this.classesByName.containsKey(className)) {
            throw new IllegalArgumentException("A class named '" + className + "' is already defined in this module");
        }
        this.classesByName.put(className, description);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public ComponentDescription getComponentByName(String name) {
        return this.componentsByName.get(name);
    }

    public ComponentDescription getComponentByClassName(String className) {
        return this.componentsByClassName.get(className);
    }

    public Collection<ComponentDescription> getComponentDescriptions() {
        return this.componentsByName.values();
    }

    public EEModuleClassDescription getClassByName(String name) {
        return this.classesByName.get(name);
    }

    public EEModuleClassDescription getOrAddClassByName(String name) {
        EEModuleClassDescription description = this.classesByName.get(name);
        if (description == null) {
            description = new EEModuleClassDescription(name);
            this.classesByName.put(name, description);
        }
        return description;
    }

    public Collection<EEModuleClassDescription> getClassDescriptions() {
        return this.classesByName.values();
    }

    public Deque<EEModuleConfigurator> getConfigurators() {
        return this.moduleConfigurators;
    }

    public InjectedEENamespaceContextSelector getNamespaceContextSelector() {
        return this.namespaceContextSelector;
    }

    public void setNamespaceContextSelector(InjectedEENamespaceContextSelector namespaceContextSelector) {
        this.namespaceContextSelector = namespaceContextSelector;
    }
}

