/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.EnvEntryReferenceSourceDescription;
import org.jboss.as.ee.component.LazyBindingSourceDescription;
import org.jboss.as.ee.component.LookupBindingSourceDescription;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;

public class EnvEntryProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    protected List<BindingDescription> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, EEModuleDescription moduleDescription, AbstractComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        ArrayList<BindingDescription> bindings = new ArrayList<BindingDescription>();
        bindings.addAll(this.getEnvironmentEntries(environment, classLoader, deploymentReflectionIndex));
        bindings.addAll(this.getResourceEnvRefEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription));
        bindings.addAll(this.getResourceRefEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription));
        return bindings;
    }

    private List<BindingDescription> getResourceEnvRefEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, AbstractComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ArrayList<BindingDescription> bindings = new ArrayList<BindingDescription>();
        ResourceEnvironmentReferencesMetaData entries = environment.getEnvironment().getResourceEnvironmentReferences();
        if (entries == null) {
            return bindings;
        }
        for (ResourceEnvironmentReferenceMetaData envEntry : entries) {
            String name = envEntry.getName().startsWith("java:") ? envEntry.getName() : environment.getDefaultContext() + envEntry.getName();
            BindingDescription description = new BindingDescription(name);
            Class classType = null;
            if (envEntry.getType() != null) {
                try {
                    classType = classLoader.loadClass(envEntry.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + envEntry.getType() + " referenced in env-entry ", (Throwable)e);
                }
            }
            description.setDependency(true);
            classType = this.processInjectionTargets(classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)envEntry, description, classType);
            description.setBindingType(classType.getName());
            if (!this.isEmpty(envEntry.getLookupName())) {
                if (componentDescription != null) {
                    description.setReferenceSourceDescription(new LookupBindingSourceDescription(envEntry.getLookupName(), componentDescription));
                } else {
                    description.setReferenceSourceDescription(new LookupBindingSourceDescription(envEntry.getLookupName(), moduleDescription));
                }
            } else {
                description.setReferenceSourceDescription(new LazyBindingSourceDescription());
            }
            bindings.add(description);
        }
        return bindings;
    }

    private List<BindingDescription> getResourceRefEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, AbstractComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ArrayList<BindingDescription> bindings = new ArrayList<BindingDescription>();
        ResourceReferencesMetaData entries = environment.getEnvironment().getResourceReferences();
        if (entries == null) {
            return bindings;
        }
        for (ResourceReferenceMetaData envEntry : entries) {
            String name = envEntry.getName().startsWith("java:") ? envEntry.getName() : environment.getDefaultContext() + envEntry.getName();
            BindingDescription description = new BindingDescription(name);
            Class classType = null;
            if (envEntry.getType() != null) {
                try {
                    classType = classLoader.loadClass(envEntry.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + envEntry.getType() + " referenced in env-entry ", (Throwable)e);
                }
            }
            description.setDependency(true);
            classType = this.processInjectionTargets(classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)envEntry, description, classType);
            description.setBindingType(classType.getName());
            if (!this.isEmpty(envEntry.getLookupName())) {
                if (componentDescription != null) {
                    description.setReferenceSourceDescription(new LookupBindingSourceDescription(envEntry.getLookupName(), componentDescription));
                } else {
                    description.setReferenceSourceDescription(new LookupBindingSourceDescription(envEntry.getLookupName(), moduleDescription));
                }
            } else {
                description.setReferenceSourceDescription(new LazyBindingSourceDescription());
            }
            bindings.add(description);
        }
        return bindings;
    }

    private List<BindingDescription> getEnvironmentEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        ArrayList<BindingDescription> bindings = new ArrayList<BindingDescription>();
        EnvironmentEntriesMetaData entries = environment.getEnvironment().getEnvironmentEntries();
        if (entries == null) {
            return bindings;
        }
        for (EnvironmentEntryMetaData envEntry : entries) {
            String name = envEntry.getName().startsWith("java:") ? envEntry.getName() : environment.getDefaultContext() + envEntry.getEnvEntryName();
            BindingDescription description = new BindingDescription(name);
            Class classType = null;
            if (envEntry.getType() != null) {
                try {
                    classType = classLoader.loadClass(envEntry.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + envEntry.getType() + " referenced in env-entry ", (Throwable)e);
                }
            }
            description.setDependency(true);
            classType = this.processInjectionTargets(classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)envEntry, description, classType);
            if (classType == null) {
                throw new DeploymentUnitProcessingException("Could not determine type for <env-entry> " + name + " please specify the <env-entry-type>. Component");
            }
            String value = envEntry.getValue();
            if (this.isEmpty(value)) continue;
            String type = classType.getName();
            description.setBindingType(classType.getName());
            if (type.equals(String.class.getName())) {
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(value));
            } else if (type.equals(Integer.class.getName())) {
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(Integer.valueOf(value)));
            } else if (type.equals(Short.class.getName())) {
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(Short.valueOf(value)));
            } else if (type.equals(Long.class.getName())) {
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(Long.valueOf(value)));
            } else if (type.equals(Byte.class.getName())) {
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(Byte.valueOf(value)));
            } else if (type.equals(Double.class.getName())) {
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(Double.valueOf(value)));
            } else if (type.equals(Float.class.getName())) {
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(Float.valueOf(value)));
            } else if (type.equals(Boolean.class.getName())) {
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(Boolean.valueOf(value)));
            } else if (type.equals(Character.class.getName())) {
                if (value.length() != 1) {
                    throw new DeploymentUnitProcessingException("env-entry of type java.lang.Character is not exactly one character long " + value);
                }
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(Character.valueOf(value.charAt(0))));
            } else if (type.equals(Class.class.getName())) {
                try {
                    description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(classLoader.loadClass(value)));
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load class " + value + " specified in env-entry");
                }
            } else if (classType.isEnum() || classType.getEnclosingClass() != null && classType.getEnclosingClass().isEnum()) {
                description.setReferenceSourceDescription(new EnvEntryReferenceSourceDescription(Enum.valueOf(classType, value)));
            } else {
                throw new DeploymentUnitProcessingException("Unkown env-entry type " + type);
            }
            bindings.add(description);
        }
        return bindings;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

