/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import javax.interceptor.InvocationContext;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class InterceptorMethodDescription {
    private final MethodIdentifier identifier;
    private final String declaringClass;
    private final boolean acceptsContext;

    public InterceptorMethodDescription(String declaringClass, MethodIdentifier identifier) {
        this.declaringClass = declaringClass;
        this.identifier = identifier;
        String[] parameterTypes = identifier.getParameterTypes();
        this.acceptsContext = parameterTypes.length == 1 && parameterTypes[0].equals(InvocationContext.class.getName());
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isAcceptsContext() {
        return this.acceptsContext;
    }

    public MethodIdentifier getIdentifier() {
        return this.identifier;
    }

    public static InterceptorMethodDescription create(String declaringClass, MethodInfo methodInfo) {
        String[] argTypes = new String[methodInfo.args().length];
        int i = 0;
        for (Type argType : methodInfo.args()) {
            argTypes[i++] = argType.name().toString();
        }
        MethodIdentifier identifier = MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])argTypes);
        return new InterceptorMethodDescription(declaringClass, identifier);
    }

    public static InterceptorMethodDescription create(MethodInfo methodInfo) {
        return InterceptorMethodDescription.create(methodInfo.declaringClass().name().toString(), methodInfo);
    }
}

