/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.HashMap;
import java.util.HashSet;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class ModuleJndiBindingProcessor
implements DeploymentUnitProcessor {
    public void deploy(final DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration == null) {
            return;
        }
        final HashMap<ServiceName, BindingConfiguration> existingBindings = new HashMap<ServiceName, BindingConfiguration>();
        final HashMap<ServiceName, BindingConfiguration> deploymentDescriptorBindings = new HashMap<ServiceName, BindingConfiguration>();
        HashSet<BindingConfiguration> bindingConfigurations = new HashSet<BindingConfiguration>(moduleConfiguration.getBindingConfigurations());
        for (BindingConfiguration binding : bindingConfigurations) {
            ServiceName serviceName = ContextNames.serviceNameOfEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
            BindingConfiguration existingConfiguration = (BindingConfiguration)existingBindings.get(serviceName);
            if (existingConfiguration != null && !existingConfiguration.equals(binding)) {
                throw new DeploymentUnitProcessingException("Multiple module level bindings with the same name at " + binding.getName() + " " + binding + " and " + existingConfiguration);
            }
            existingBindings.put(serviceName, binding);
            deploymentDescriptorBindings.put(serviceName, binding);
            this.addJndiBinding(moduleConfiguration, binding, phaseContext, serviceName);
        }
        for (ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            HashSet<BindingConfiguration> componentLevelBindings = new HashSet<BindingConfiguration>(componentConfiguration.getBindingConfigurations());
            for (BindingConfiguration binding : componentLevelBindings) {
                boolean compBinding;
                String bindingName = binding.getName();
                boolean bl = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                if (componentConfiguration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE && compBinding) continue;
                ServiceName serviceName = ContextNames.serviceNameOfEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
                BindingConfiguration existingConfiguration = (BindingConfiguration)existingBindings.get(serviceName);
                if (existingConfiguration != null && !existingConfiguration.equals(binding)) {
                    throw new DeploymentUnitProcessingException("Multiple module level bindings with the same name at " + binding.getName() + " " + binding + " and " + existingConfiguration);
                }
                existingBindings.put(serviceName, binding);
                deploymentDescriptorBindings.put(serviceName, binding);
                this.addJndiBinding(moduleConfiguration, binding, phaseContext, serviceName);
            }
        }
        final HashSet handledClasses = new HashSet();
        for (final ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            HashSet<EEModuleClassConfiguration> classConfigurations = new HashSet<EEModuleClassConfiguration>();
            classConfigurations.add(componentConfiguration.getModuleClassConfiguration());
            for (InterceptorDescription interceptor : componentConfiguration.getComponentDescription().getAllInterceptors().values()) {
                EEModuleClassConfiguration interceptorClass = moduleConfiguration.getClassConfiguration(interceptor.getInterceptorClassName());
                if (interceptorClass == null) continue;
                classConfigurations.add(interceptorClass);
            }
            for (EEModuleClassConfiguration classConfiguration : classConfigurations) {
                new ClassDescriptionTraversal(classConfiguration, moduleConfiguration){

                    @Override
                    protected void handle(EEModuleClassConfiguration configuration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                        if (handledClasses.contains(classDescription.getClassName())) {
                            return;
                        }
                        handledClasses.add(classDescription.getClassName());
                        HashSet<BindingConfiguration> classLevelBindings = new HashSet<BindingConfiguration>(configuration.getBindingConfigurations());
                        for (BindingConfiguration binding : classLevelBindings) {
                            ServiceName serviceName;
                            boolean compBinding;
                            String bindingName = binding.getName();
                            boolean bl = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                            if (componentConfiguration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE && compBinding || deploymentDescriptorBindings.containsKey(serviceName = ContextNames.serviceNameOfEnvEntry((String)this.moduleConfiguration.getApplicationName(), (String)this.moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName()))) continue;
                            BindingConfiguration existingConfiguration = (BindingConfiguration)existingBindings.get(serviceName);
                            if (existingConfiguration != null && !existingConfiguration.equals(binding)) {
                                throw new DeploymentUnitProcessingException("Bindings with the same name at " + binding.getName() + " " + binding + " and " + existingConfiguration);
                            }
                            existingBindings.put(serviceName, binding);
                            ModuleJndiBindingProcessor.this.addJndiBinding(this.moduleConfiguration, binding, phaseContext, serviceName);
                        }
                    }
                }.run();
            }
        }
    }

    protected void addJndiBinding(EEModuleConfiguration module, BindingConfiguration bindingConfiguration, DeploymentPhaseContext phaseContext, ServiceName serviceName) throws DeploymentUnitProcessingException {
        BinderService service;
        String bindingName;
        String string = bindingName = bindingConfiguration.getName().startsWith("java:") ? bindingConfiguration.getName() : "java:module/env/" + bindingConfiguration.getName();
        if (bindingName != null) {
            service = new BinderService(bindingName);
            if (serviceName == null) {
                throw new IllegalArgumentException("Invalid context name '" + bindingName + "' for binding");
            }
        } else {
            throw new DeploymentUnitProcessingException("Binding name must not be null: " + bindingConfiguration);
        }
        ServiceBuilder sourceServiceBuilder = phaseContext.getServiceTarget().addService(serviceName, (Service)service);
        InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(true, module.getModuleName(), module.getModuleName(), module.getApplicationName());
        bindingConfiguration.getSource().getResourceValue(resolutionContext, sourceServiceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
        ServiceController resourceValue = sourceServiceBuilder.addDependency(serviceName.getParent(), NamingStore.class, service.getNamingStoreInjector()).install();
    }

    public void undeploy(DeploymentUnit context) {
    }
}

