/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.interceptors.OrderedItemContainer;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.msc.service.ServiceName;

public class ViewConfiguration {
    private final ComponentConfiguration componentConfiguration;
    private final ServiceName viewServiceName;
    private final Map<Method, OrderedItemContainer<InterceptorFactory>> viewInterceptors = new IdentityHashMap<Method, OrderedItemContainer<InterceptorFactory>>();
    private final Map<Method, OrderedItemContainer<InterceptorFactory>> clientInterceptors = new IdentityHashMap<Method, OrderedItemContainer<InterceptorFactory>>();
    private final OrderedItemContainer<InterceptorFactory> viewPostConstructInterceptors = new OrderedItemContainer();
    private final OrderedItemContainer<InterceptorFactory> clientPostConstructInterceptors = new OrderedItemContainer();
    private final OrderedItemContainer<InterceptorFactory> viewPreDestroyInterceptors = new OrderedItemContainer();
    private final OrderedItemContainer<InterceptorFactory> clientPreDestroyInterceptors = new OrderedItemContainer();
    private final ProxyFactory<?> proxyFactory;
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final Class<?> viewClass;

    public ViewConfiguration(Class<?> viewClass, ComponentConfiguration componentConfiguration, ServiceName viewServiceName, ProxyFactory<?> proxyFactory) {
        this.componentConfiguration = componentConfiguration;
        this.viewServiceName = viewServiceName;
        this.proxyFactory = proxyFactory;
        this.viewClass = viewClass;
    }

    public ComponentConfiguration getComponentConfiguration() {
        return this.componentConfiguration;
    }

    public ServiceName getViewServiceName() {
        return this.viewServiceName;
    }

    public List<InterceptorFactory> getViewInterceptors(Method method) {
        OrderedItemContainer<InterceptorFactory> container = this.viewInterceptors.get(method);
        if (container == null) {
            return Collections.emptyList();
        }
        return container.getSortedItems();
    }

    public void addViewInterceptor(InterceptorFactory interceptorFactory, int priority) {
        for (Method method : this.proxyFactory.getCachedMethods()) {
            this.addViewInterceptor(method, interceptorFactory, priority);
        }
    }

    public void addViewInterceptor(Method method, InterceptorFactory interceptorFactory, int priority) {
        OrderedItemContainer<Object> container = this.viewInterceptors.get(method);
        if (container == null) {
            container = new OrderedItemContainer();
            this.viewInterceptors.put(method, container);
        }
        container.add(interceptorFactory, priority);
    }

    public List<InterceptorFactory> getClientInterceptors(Method method) {
        OrderedItemContainer<InterceptorFactory> container = this.clientInterceptors.get(method);
        if (container == null) {
            return Collections.emptyList();
        }
        return container.getSortedItems();
    }

    public void addClientInterceptor(InterceptorFactory interceptorFactory, int priority) {
        for (Method method : this.proxyFactory.getCachedMethods()) {
            this.addClientInterceptor(method, interceptorFactory, priority);
        }
    }

    public void addClientInterceptor(Method method, InterceptorFactory interceptorFactory, int priority) {
        OrderedItemContainer<Object> container = this.clientInterceptors.get(method);
        if (container == null) {
            container = new OrderedItemContainer();
            this.clientInterceptors.put(method, container);
        }
        container.add(interceptorFactory, priority);
    }

    public List<InterceptorFactory> getViewPostConstructInterceptors() {
        return this.viewPostConstructInterceptors.getSortedItems();
    }

    public void addViewPostConstructInterceptor(InterceptorFactory interceptorFactory, int priority) {
        this.viewPostConstructInterceptors.add(interceptorFactory, priority);
    }

    public List<InterceptorFactory> getClientPostConstructInterceptors() {
        return this.clientPostConstructInterceptors.getSortedItems();
    }

    public void addClientPostConstructInterceptor(InterceptorFactory interceptorFactory, int priority) {
        this.clientPostConstructInterceptors.add(interceptorFactory, priority);
    }

    public List<InterceptorFactory> getViewPreDestroyInterceptors() {
        return this.viewPreDestroyInterceptors.getSortedItems();
    }

    public void addViewPreDestroyInterceptor(InterceptorFactory interceptorFactory, int priority) {
        this.viewPreDestroyInterceptors.add(interceptorFactory, priority);
    }

    public List<InterceptorFactory> getClientPreDestroyInterceptors() {
        return this.clientPreDestroyInterceptors.getSortedItems();
    }

    public void addClientPreDestroyInterceptor(InterceptorFactory interceptorFactory, int priority) {
        this.clientPreDestroyInterceptors.add(interceptorFactory, priority);
    }

    public ProxyFactory<?> getProxyFactory() {
        return this.proxyFactory;
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    public Class<?> getViewClass() {
        return this.viewClass;
    }
}

