/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.EEModuleConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LazyResourceInjection;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;
import org.jboss.modules.Module;

public abstract class AbstractDeploymentDescriptorBindingsProcessor
implements DeploymentUnitProcessor {
    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentDescriptorEnvironment environment = (DeploymentDescriptorEnvironment)deploymentUnit.getAttachment(Attachments.MODULE_DEPLOYMENT_DESCRIPTOR_ENVIRONMENT);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (description == null) {
            return;
        }
        if (environment != null) {
            final List<BindingConfiguration> bindings = this.processDescriptorEntries(deploymentUnit, environment, description, null, (ClassLoader)module.getClassLoader(), deploymentReflectionIndex, applicationClasses);
            this.handleLazyBindings(applicationClasses, bindings);
            description.getConfigurators().add(new EEModuleConfigurator(){

                @Override
                public void configure(DeploymentPhaseContext context, EEModuleDescription description, EEModuleConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.getBindingConfigurations().addAll(bindings);
                }
            });
        }
        for (ComponentDescription componentDescription : description.getComponentDescriptions()) {
            if (componentDescription.getDeploymentDescriptorEnvironment() == null) continue;
            List<BindingConfiguration> bindings = this.processDescriptorEntries(deploymentUnit, componentDescription.getDeploymentDescriptorEnvironment(), description, componentDescription, (ClassLoader)module.getClassLoader(), deploymentReflectionIndex, applicationClasses);
            this.handleLazyBindings(applicationClasses, bindings);
            componentDescription.getBindingConfigurations().addAll(bindings);
        }
    }

    private void handleLazyBindings(EEApplicationClasses description, List<BindingConfiguration> bindings) {
        for (BindingConfiguration binding : bindings) {
            List<LazyResourceInjection> lazyInjections;
            String name = binding.getName();
            if (!name.startsWith("java:")) {
                name = "java:comp/" + name;
            }
            if ((lazyInjections = description.getLazyResourceInjections().get(name)) == null) continue;
            for (LazyResourceInjection injection : lazyInjections) {
                injection.install();
            }
            description.getLazyResourceInjections().remove(name);
        }
    }

    protected abstract List<BindingConfiguration> processDescriptorEntries(DeploymentUnit var1, DeploymentDescriptorEnvironment var2, EEModuleDescription var3, ComponentDescription var4, ClassLoader var5, DeploymentReflectionIndex var6, EEApplicationClasses var7) throws DeploymentUnitProcessingException;

    public void undeploy(DeploymentUnit context) {
    }

    protected Class<?> processInjectionTargets(EEModuleDescription moduleDescription, EEApplicationClasses applicationClasses, InjectionSource injectionSource, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, ResourceInjectionMetaDataWithDescriptions entry, Class<?> classType) throws DeploymentUnitProcessingException {
        if (entry.getInjectionTargets() != null) {
            for (ResourceInjectionTargetMetaData injectionTarget : entry.getInjectionTargets()) {
                Class<?> current;
                Class<?> injectionTargetClass;
                try {
                    injectionTargetClass = classLoader.loadClass(injectionTarget.getInjectionTargetClass());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + injectionTarget.getInjectionTargetClass() + " referenced in env-entry injection point ", (Throwable)e);
                }
                EEModuleClassDescription eeModuleClassDescription = applicationClasses.getOrAddClassByName(injectionTargetClass.getName());
                ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(injectionTargetClass);
                String methodName = "set" + injectionTarget.getInjectionTargetName().substring(0, 1).toUpperCase() + injectionTarget.getInjectionTargetName().substring(1);
                boolean methodFound = false;
                Method method = null;
                Field field = null;
                Class<?> injectionTargetType = null;
                String memberName = injectionTarget.getInjectionTargetName();
                for (current = injectionTargetClass; current != Object.class && current != null && !methodFound; current = current.getSuperclass()) {
                    Collection methods = index.getAllMethods(methodName);
                    for (Method m : methods) {
                        if (m.getParameterTypes().length != 1 || m.isBridge() || m.isSynthetic()) continue;
                        if (methodFound) {
                            throw new DeploymentUnitProcessingException("Two setter methods for " + injectionTarget.getInjectionTargetName() + " on class " + injectionTarget.getInjectionTargetClass() + " found when applying <injection-target> for env-entry");
                        }
                        methodFound = true;
                        method = m;
                        injectionTargetType = m.getParameterTypes()[0];
                        memberName = methodName;
                    }
                }
                if (method == null) {
                    for (current = injectionTargetClass; current != Object.class && current != null && field == null; current = current.getSuperclass()) {
                        field = index.getField(injectionTarget.getInjectionTargetName());
                        if (field == null) continue;
                        injectionTargetType = field.getType();
                        memberName = injectionTarget.getInjectionTargetName();
                        break;
                    }
                }
                if (field == null && method == null) {
                    throw new DeploymentUnitProcessingException("Could not resolve injection point " + injectionTarget.getInjectionTargetName() + " on class " + injectionTarget.getInjectionTargetClass() + " specified in web.xml");
                }
                if (classType != null) {
                    if (!classType.isAssignableFrom(injectionTargetType)) {
                        throw new DeploymentUnitProcessingException("Injection target " + injectionTarget.getInjectionTargetName() + " on class " + injectionTarget.getInjectionTargetClass() + " is not compatible with the type of injection");
                    }
                } else {
                    classType = injectionTargetType;
                }
                InjectionTarget injectionTargetDescription = method == null ? new FieldInjectionTarget(eeModuleClassDescription.getClassName(), memberName, classType.getName()) : new MethodInjectionTarget(eeModuleClassDescription.getClassName(), memberName, classType.getName());
                final ResourceInjectionConfiguration injectionConfiguration = new ResourceInjectionConfiguration(injectionTargetDescription, injectionSource);
                eeModuleClassDescription.getConfigurators().add(new ClassConfigurator(){

                    @Override
                    public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
                        configuration.getInjectionConfigurations().add(injectionConfiguration);
                    }
                });
            }
        }
        return classType;
    }
}

