/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.Collection;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;

public class EEModuleConfigurationProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EEModuleConfigurationProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (moduleDescription == null) {
            return;
        }
        if (module == null) {
            return;
        }
        EEModuleConfiguration moduleConfiguration = new EEModuleConfiguration(moduleDescription, phaseContext, module);
        deploymentUnit.putAttachment(Attachments.EE_MODULE_CONFIGURATION, (Object)moduleConfiguration);
        Collection<ComponentDescription> componentDescriptions = moduleDescription.getComponentDescriptions();
        if (componentDescriptions != null) {
            for (ComponentDescription componentDescription : componentDescriptions) {
                logger.debug((Object)("Configuring component class: " + componentDescription.getComponentClassName() + " named " + componentDescription.getComponentName()));
                ComponentConfiguration componentConfiguration = componentDescription.createConfiguration(applicationDescription);
                for (ComponentConfigurator componentConfigurator : componentDescription.getConfigurators()) {
                    componentConfigurator.configure(phaseContext, componentDescription, componentConfiguration);
                }
                moduleConfiguration.addComponentConfiguration(componentConfiguration);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

