/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class ModuleJndiBindingProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(ModuleJndiBindingProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration == null) {
            return;
        }
        Set dependencies = (Set)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES);
        HashMap<ServiceName, BindingConfiguration> deploymentDescriptorBindings = new HashMap<ServiceName, BindingConfiguration>();
        IntHolder moduleCount = new IntHolder();
        List<BindingConfiguration> bindingConfigurations = moduleConfiguration.getBindingConfigurations();
        ServiceName moduleOwnerName = deploymentUnit.getServiceName().append(new String[]{"module"}).append(new String[]{moduleConfiguration.getApplicationName()}).append(new String[]{moduleConfiguration.getModuleName()});
        for (BindingConfiguration binding : bindingConfigurations) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
            deploymentDescriptorBindings.put(bindInfo.getBinderServiceName(), binding);
            this.addJndiBinding(moduleConfiguration, binding, phaseContext, bindInfo.getBinderServiceName(), moduleOwnerName, moduleCount, dependencies);
        }
        for (ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            for (BindingConfiguration binding : componentConfiguration.getComponentDescription().getBindingConfigurations()) {
                boolean compBinding;
                String bindingName = binding.getName();
                boolean bl = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                if (componentConfiguration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE && compBinding) continue;
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
                deploymentDescriptorBindings.put(bindInfo.getBinderServiceName(), binding);
                this.addJndiBinding(moduleConfiguration, binding, phaseContext, bindInfo.getBinderServiceName(), moduleOwnerName, moduleCount, dependencies);
            }
        }
        HashSet<String> handledClasses = new HashSet<String>();
        for (ComponentConfiguration componentConfiguration : moduleConfiguration.getComponentConfigurations()) {
            HashSet<EEModuleClassConfiguration> classConfigurations = new HashSet<EEModuleClassConfiguration>();
            classConfigurations.add(componentConfiguration.getModuleClassConfiguration());
            for (InterceptorDescription interceptor : componentConfiguration.getComponentDescription().getAllInterceptors()) {
                EEModuleClassConfiguration interceptorClass = applicationDescription.getClassConfiguration(interceptor.getInterceptorClassName());
                if (interceptorClass == null) continue;
                classConfigurations.add(interceptorClass);
            }
            this.processClassConfigurations(phaseContext, applicationDescription, moduleConfiguration, deploymentDescriptorBindings, handledClasses, componentConfiguration.getComponentDescription().getNamingMode(), classConfigurations, componentConfiguration.getComponentName(), moduleOwnerName, moduleCount, dependencies);
        }
    }

    private void processClassConfigurations(final DeploymentPhaseContext phaseContext, EEApplicationDescription applicationDescription, final EEModuleConfiguration moduleConfiguration, final Map<ServiceName, BindingConfiguration> deploymentDescriptorBindings, final Set<String> handledClasses, final ComponentNamingMode namingMode, Set<EEModuleClassConfiguration> classConfigurations, final String componentName, final ServiceName ownerName, final IntHolder handleCount, final Set<ServiceName> dependencies) throws DeploymentUnitProcessingException {
        for (EEModuleClassConfiguration classConfiguration : classConfigurations) {
            new ClassDescriptionTraversal(classConfiguration, applicationDescription){

                @Override
                protected void handle(EEModuleClassConfiguration configuration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    if (classDescription.isInvalid()) {
                        throw new DeploymentUnitProcessingException("Component class " + classDescription.getClassName() + " for component " + componentName + " has errors: \n " + classDescription.getInvalidMessage());
                    }
                    if (handledClasses.contains(classDescription.getClassName())) {
                        return;
                    }
                    handledClasses.add(classDescription.getClassName());
                    HashSet<BindingConfiguration> classLevelBindings = new HashSet<BindingConfiguration>(configuration.getBindingConfigurations());
                    for (BindingConfiguration binding : classLevelBindings) {
                        boolean compBinding;
                        String bindingName = binding.getName();
                        boolean bl = compBinding = bindingName.startsWith("java:comp") || !bindingName.startsWith("java:");
                        if (namingMode == ComponentNamingMode.CREATE && compBinding) continue;
                        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)moduleConfiguration.getApplicationName(), (String)moduleConfiguration.getModuleName(), null, (boolean)false, (String)binding.getName());
                        logger.tracef("Binding %s using service %s", (Object)binding.getName(), (Object)bindInfo.getBinderServiceName());
                        if (deploymentDescriptorBindings.containsKey(bindInfo.getBinderServiceName())) continue;
                        ModuleJndiBindingProcessor.this.addJndiBinding(moduleConfiguration, binding, phaseContext, bindInfo.getBinderServiceName(), ownerName, handleCount, dependencies);
                    }
                }
            }.run();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addJndiBinding(EEModuleConfiguration module, BindingConfiguration bindingConfiguration, DeploymentPhaseContext phaseContext, ServiceName serviceName, ServiceName ownerName, IntHolder handleCount, Set<ServiceName> dependencies) throws DeploymentUnitProcessingException {
        BinderService service;
        String bindingName = bindingConfiguration.getName().startsWith("java:") ? bindingConfiguration.getName() : "java:module/env/" + bindingConfiguration.getName();
        ServiceVerificationHandler serviceVerificationHandler = (ServiceVerificationHandler)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.SERVICE_VERIFICATION_HANDLER);
        InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(true, module.getModuleName(), module.getModuleName(), module.getApplicationName());
        if (bindingName == null) throw new DeploymentUnitProcessingException("Binding name must not be null: " + bindingConfiguration);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)module.getApplicationName(), (String)module.getModuleName(), (String)module.getModuleName(), (boolean)false, (String)bindingName);
        if (bindingName.startsWith("java:comp") || bindingName.startsWith("java:module") || bindingName.startsWith("java:app")) {
            try {
                BinderService service2 = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource());
                dependencies.add(bindInfo.getBinderServiceName());
                ServiceBuilder serviceBuilder = phaseContext.getServiceTarget().addService(bindInfo.getBinderServiceName(), (Service)service2);
                bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service2.getManagedObjectInjector());
                serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, service2.getNamingStoreInjector());
                serviceBuilder.install();
                return;
            }
            catch (DuplicateServiceException e) {
                ServiceController registered = CurrentServiceContainer.getServiceContainer().getService(bindInfo.getBinderServiceName());
                if (registered == null) {
                    throw e;
                }
                BinderService service3 = (BinderService)registered.getService();
                if (service3.getSource().equals(bindingConfiguration.getSource())) return;
                throw new IllegalArgumentException("Incompatible conflicting binding at " + bindingName + " source: " + bindingConfiguration.getSource());
            }
        }
        ServiceController controller = null;
        try {
            service = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource());
            dependencies.add(bindInfo.getBinderServiceName());
            ServiceBuilder serviceBuilder = CurrentServiceContainer.getServiceContainer().addService(bindInfo.getBinderServiceName(), (Service)service);
            bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
            serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, service.getNamingStoreInjector());
            serviceBuilder.addListener((ServiceListener)serviceVerificationHandler);
            controller = serviceBuilder.install();
            service.acquire();
        }
        catch (DuplicateServiceException e) {
            controller = CurrentServiceContainer.getServiceContainer().getService(bindInfo.getBinderServiceName());
            if (controller == null) {
                throw e;
            }
            service = (BinderService)controller.getService();
            if (!service.getSource().equals(bindingConfiguration.getSource())) {
                throw new IllegalArgumentException("Incompatible conflicting binding at " + bindingName + " source: " + bindingConfiguration.getSource());
            }
            service.acquire();
        }
        ServiceController unitService = CurrentServiceContainer.getServiceContainer().getService(phaseContext.getDeploymentUnit().getServiceName());
        BinderService binderService = service;
        unitService.addListener(new BinderReleaseListener(binderService));
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static class BinderReleaseListener<T>
    extends AbstractServiceListener<T> {
        private final BinderService binderService;

        public BinderReleaseListener(BinderService binderService) {
            this.binderService = binderService;
        }

        public void listenerAdded(ServiceController<? extends T> serviceController) {
            if (serviceController.getState() == ServiceController.State.DOWN || serviceController.getState() == ServiceController.State.STOPPING) {
                this.binderService.release();
                serviceController.removeListener((ServiceListener)this);
            }
        }

        public void transition(ServiceController<? extends T> serviceController, ServiceController.Transition transition) {
            if (transition.getAfter() == ServiceController.Substate.STOPPING) {
                this.binderService.release();
                serviceController.removeListener((ServiceListener)this);
            }
        }
    }

    private static class IntHolder {
        private int value = 0;

        private IntHolder() {
        }
    }
}

