/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.Attachments;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.ee.naming.JavaNamespaceSetup;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Values;

public class ModuleContextProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName appContextServiceName = ContextNames.contextServiceNameOfApplication((String)moduleDescription.getApplicationName());
        ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
        NamingStoreService contextService = new NamingStoreService();
        serviceTarget.addService(moduleContextServiceName, (Service)contextService).install();
        BinderService moduleNameBinder = new BinderService("ModuleName");
        serviceTarget.addService(moduleContextServiceName.append(new String[]{"ModuleName"}), (Service)moduleNameBinder).addInjection(moduleNameBinder.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory(Values.immediateValue((Object)moduleDescription.getModuleName()))).addDependency(moduleContextServiceName, ServiceBasedNamingStore.class, moduleNameBinder.getNamingStoreInjector()).install();
        deploymentUnit.putAttachment(Attachments.MODULE_CONTEXT_CONFIG, (Object)moduleContextServiceName);
        InjectedEENamespaceContextSelector selector = new InjectedEENamespaceContextSelector();
        phaseContext.addDependency(appContextServiceName, NamingStore.class, selector.getAppContextInjector());
        phaseContext.addDependency(moduleContextServiceName, NamingStore.class, selector.getModuleContextInjector());
        phaseContext.addDependency(moduleContextServiceName, NamingStore.class, selector.getCompContextInjector());
        phaseContext.addDependency(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, NamingStore.class, selector.getJbossContextInjector());
        phaseContext.addDependency(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, NamingStore.class, selector.getGlobalContextInjector());
        moduleDescription.setNamespaceContextSelector(selector);
        JavaNamespaceSetup setupAction = new JavaNamespaceSetup(selector);
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.SETUP_ACTIONS, (Object)setupAction);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

