/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.ee.component.deployers.DefaultEarSubDeploymentsIsolationProcessor;
import org.jboss.as.ee.structure.GlobalModuleDependencyProcessor;
import org.jboss.as.ee.subsystem.Attribute;
import org.jboss.as.ee.subsystem.CommonAttributes;
import org.jboss.as.ee.subsystem.EeSubsystemAdd;
import org.jboss.as.ee.subsystem.EeSubsystemDescriptions;
import org.jboss.as.ee.subsystem.EeSubsystemRemove;
import org.jboss.as.ee.subsystem.EeWriteAttributeHandler;
import org.jboss.as.ee.subsystem.Element;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.ee.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class EeExtension
implements Extension {
    public static final String NAMESPACE = "urn:jboss:domain:ee:1.0";
    private static final String SUBSYSTEM_NAME = "ee";
    private static final EESubsystemParser parser = new EESubsystemParser();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return EeSubsystemDescriptions.getSubsystemDescription(locale);
            }
        });
        DefaultEarSubDeploymentsIsolationProcessor isolationProcessor = new DefaultEarSubDeploymentsIsolationProcessor();
        GlobalModuleDependencyProcessor moduleDependencyProcessor = new GlobalModuleDependencyProcessor();
        EeSubsystemAdd subsystemAdd = new EeSubsystemAdd(isolationProcessor, moduleDependencyProcessor);
        registration.registerOperationHandler("add", (OperationStepHandler)subsystemAdd, (DescriptionProvider)subsystemAdd, false);
        registration.registerOperationHandler("remove", (OperationStepHandler)EeSubsystemRemove.INSTANCE, (DescriptionProvider)EeSubsystemRemove.INSTANCE, false, OperationEntry.EntryType.PUBLIC, EnumSet.of(OperationEntry.Flag.RESTART_ALL_SERVICES));
        registration.registerOperationHandler("describe", (OperationStepHandler)EESubsystemDescribeHandler.INSTANCE, (DescriptionProvider)EESubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        EeWriteAttributeHandler writeHandler = new EeWriteAttributeHandler(isolationProcessor, moduleDependencyProcessor);
        writeHandler.registerAttributes(registration);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(NAMESPACE, (XMLElementReader)parser);
    }

    static ModelNode createEESubSystemAddOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    private static class EESubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final EESubsystemDescribeHandler INSTANCE = new EESubsystemDescribeHandler();

        private EESubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
            ModelNode op = EeExtension.createEESubSystemAddOperation();
            if (model.hasDefined("global-modules")) {
                op.get("global-modules").set(model.get("global-modules"));
            }
            if (model.hasDefined(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName())) {
                op.get(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName()).set(model.get(Element.EAR_SUBDEPLOYMENTS_ISOLATED.getLocalName()));
            }
            context.getResult().add(op);
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static class EESubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        EESubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(EeExtension.NAMESPACE, false);
            ModelNode eeSubSystem = context.getModelNode();
            CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
            GlobalModulesDefinition.INSTANCE.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode eeSubSystem = EeExtension.createEESubSystemAddOperation();
            list.add(eeSubSystem);
            EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case EE_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (!encountered.add(element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        switch (element) {
                            case GLOBAL_MODULES: {
                                ModelNode model = EESubsystemParser.parseGlobalModules(reader);
                                eeSubSystem.get("global-modules").set(model);
                                continue block7;
                            }
                            case EAR_SUBDEPLOYMENTS_ISOLATED: {
                                Location location = reader.getLocation();
                                String earSubDeploymentsIsolated = EESubsystemParser.parseEarSubDeploymentsIsolatedElement(reader);
                                CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.parseAndSetParameter(earSubDeploymentsIsolated, eeSubSystem, location);
                                continue block7;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        static ModelNode parseGlobalModules(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode globalModules = new ModelNode();
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Element.forName(reader.getLocalName())) {
                    case MODULE: {
                        int count = reader.getAttributeCount();
                        String name = null;
                        String slot = null;
                        block8: for (int i = 0; i < count; ++i) {
                            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                            String value = reader.getAttributeValue(i);
                            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                            switch (attribute) {
                                case NAME: {
                                    if (name != null) {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                    name = value;
                                    continue block8;
                                }
                                case SLOT: {
                                    if (slot != null) {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                    slot = value;
                                    continue block8;
                                }
                                default: {
                                    ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                            }
                        }
                        if (name == null) {
                            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
                        }
                        if (slot == null) {
                            slot = "main";
                        }
                        ModelNode module = new ModelNode();
                        module.get("name").set(name);
                        module.get("slot").set(slot);
                        globalModules.add(module);
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                        continue block7;
                    }
                }
                ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return globalModules;
        }

        static String parseEarSubDeploymentsIsolatedElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            String value = reader.getElementText();
            if (value == null || value.trim().isEmpty()) {
                throw new XMLStreamException("Invalid value: " + value + " for '" + (Object)((Object)Element.EAR_SUBDEPLOYMENTS_ISOLATED) + "' element", reader.getLocation());
            }
            return value.trim();
        }
    }
}

