/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.ee.subsystem.Attribute;
import org.jboss.as.ee.subsystem.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GlobalModulesDefinition
extends ListAttributeDefinition {
    private static final ParameterValidator moduleValidator;
    public static final GlobalModulesDefinition INSTANCE;

    private GlobalModulesDefinition() {
        super("global-modules", true, moduleValidator);
    }

    public ModelNode validateResolvedOperation(ModelNode operationObject) throws OperationFailedException {
        ModelNode result = super.validateOperation(operationObject);
        if (result.isDefined()) {
            for (ModelNode module : result.asList()) {
                if (module.hasDefined("slot")) continue;
                module.get("slot").set("main");
            }
        }
        return result;
    }

    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        ModelNode valueType = node.get("value-type");
        ModelNode name = valueType.get("name");
        name.get("description").set(bundle.getString("ee.global-module.name"));
        name.get("type").set(ModelType.STRING);
        name.get("nillable").set(false);
        ModelNode slot = valueType.get("slot");
        slot.get("description").set(bundle.getString("ee.global-module.slot"));
        slot.get("type").set(ModelType.STRING);
        slot.get("nillable").set(true);
    }

    public void marshallAsElement(ModelNode eeSubSystem, XMLStreamWriter writer) throws XMLStreamException {
        if (eeSubSystem.hasDefined(this.getName()) && eeSubSystem.asInt() > 0) {
            writer.writeStartElement(Element.GLOBAL_MODULES.getLocalName());
            ModelNode globalModules = eeSubSystem.get(this.getName());
            for (ModelNode module : globalModules.asList()) {
                writer.writeEmptyElement(Element.MODULE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), module.get("name").asString());
                if (!module.hasDefined("slot")) continue;
                writer.writeAttribute(Attribute.SLOT.getLocalName(), module.get("slot").asString());
            }
            writer.writeEndElement();
        }
    }

    static {
        ParametersValidator delegate = new ParametersValidator();
        delegate.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        delegate.registerValidator("slot", (ParameterValidator)new StringLengthValidator(1, true));
        moduleValidator = new ParametersOfValidator(delegate);
        INSTANCE = new GlobalModulesDefinition();
    }
}

