/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ee.component.deployers.DefaultEarSubDeploymentsIsolationProcessor;
import org.jboss.as.ee.structure.GlobalModuleDependencyProcessor;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.dmr.ModelNode;

public class EeWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final DefaultEarSubDeploymentsIsolationProcessor isolationProcessor;
    private final GlobalModuleDependencyProcessor moduleDependencyProcessor;

    public EeWriteAttributeHandler(DefaultEarSubDeploymentsIsolationProcessor isolationProcessor, GlobalModuleDependencyProcessor moduleDependencyProcessor) {
        super(new AttributeDefinition[]{GlobalModulesDefinition.INSTANCE, EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED});
        this.isolationProcessor = isolationProcessor;
        this.moduleDependencyProcessor = moduleDependencyProcessor;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        registry.registerReadWriteAttribute((AttributeDefinition)GlobalModulesDefinition.INSTANCE, null, (OperationStepHandler)this);
        registry.registerReadWriteAttribute((AttributeDefinition)EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED, null, (OperationStepHandler)this);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        this.applyUpdateToDeploymentUnitProcessor(context, operation, attributeName);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode revertOp = operation.clone();
        revertOp.get(attributeName).set(valueToRestore);
        this.applyUpdateToDeploymentUnitProcessor(context, revertOp, attributeName);
    }

    private void applyUpdateToDeploymentUnitProcessor(OperationContext context, ModelNode operation, String attributeName) throws OperationFailedException {
        if (GlobalModulesDefinition.INSTANCE.getName().equals(attributeName)) {
            ModelNode globalMods = GlobalModulesDefinition.INSTANCE.resolveModelAttribute(context, operation);
            this.moduleDependencyProcessor.setGlobalModules(globalMods);
        } else if (EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED.getName().equals(attributeName)) {
            boolean isolate = EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED.resolveModelAttribute(context, operation).asBoolean();
            this.isolationProcessor.setEarSubDeploymentsIsolated(isolate);
        }
    }
}

