/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.xa.XAException;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.registry.RegistryCollector;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.utils.DescriptorUtils;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.interceptors.AsyncInvocationTask;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.remote.DefaultEjbClientContextService;
import org.jboss.as.ejb3.remote.EJBRemoteConnectorService;
import org.jboss.as.ejb3.remote.LocalInvocationClassCloner;
import org.jboss.as.ejb3.remote.RemotingConnectionClusterNodeManager;
import org.jboss.as.ejb3.util.ServiceLookupValue;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.remoting.NetworkUtil;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;
import org.jboss.marshalling.cloner.ClassCloner;
import org.jboss.marshalling.cloner.ClassLoaderClassCloner;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectCloners;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

public class LocalEjbReceiver
extends EJBReceiver
implements Service<LocalEjbReceiver>,
RegistryCollector.Listener<String, List<ClientMapping>> {
    private static final Logger logger = Logger.getLogger(LocalEjbReceiver.class);
    public static final ServiceName DEFAULT_LOCAL_EJB_RECEIVER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb"}).append(new String[]{"default-local-ejb-receiver-service"});
    public static final ServiceName BY_VALUE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "localEjbReceiver", "value"});
    public static final ServiceName BY_REFERENCE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "localEjbReceiver", "reference"});
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final List<EJBReceiverContext> contexts = new CopyOnWriteArrayList<EJBReceiverContext>();
    private final InjectedValue<DeploymentRepository> deploymentRepository = new InjectedValue();
    private final InjectedValue<RegistryCollector> clusterRegistryCollector = new InjectedValue();
    private final Listener deploymentListener = new Listener();
    private final boolean allowPassByReference;
    private final ServiceLookupValue<Endpoint> endpointValue;
    private final ServiceLookupValue<EJBRemoteConnectorService> ejbRemoteConnectorServiceValue;
    private final Set<ClusterTopologyUpdateListener> clusterTopologyUpdateListeners = Collections.synchronizedSet(new HashSet());

    public LocalEjbReceiver(String nodeName, boolean allowPassByReference, ServiceLookupValue<Endpoint> endpointValue, ServiceLookupValue<EJBRemoteConnectorService> ejbRemoteConnectorServiceValue) {
        super(nodeName);
        this.allowPassByReference = allowPassByReference;
        this.endpointValue = endpointValue;
        this.ejbRemoteConnectorServiceValue = ejbRemoteConnectorServiceValue;
    }

    protected void associate(EJBReceiverContext receiverContext) {
        this.contexts.add(receiverContext);
        RegistryCollector clusters = (RegistryCollector)this.clusterRegistryCollector.getOptionalValue();
        if (clusters == null) {
            return;
        }
        for (Registry cluster : clusters.getRegistries()) {
            this.addClusterNodes(receiverContext.getClientContext(), cluster.getName(), cluster.getEntries());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processInvocation(EJBClientInvocationContext invocation, EJBReceiverInvocationContext receiverContext) throws Exception {
        Object result;
        Object[] parameters;
        EJBLocator locator = invocation.getLocator();
        EjbDeploymentInformation ejb = this.findBean(locator.getAppName(), locator.getModuleName(), locator.getDistinctName(), locator.getBeanName());
        EJBComponent ejbComponent = ejb.getEjbComponent();
        Class viewClass = invocation.getViewClass();
        final ComponentView view = ejb.getView(viewClass.getName());
        if (view == null) {
            throw EjbLogger.EJB3_LOGGER.viewNotFound(viewClass.getName(), ejb.getEjbName());
        }
        ClonerConfiguration paramConfig = new ClonerConfiguration();
        paramConfig.setClassCloner((ClassCloner)new ClassLoaderClassCloner(ejb.getDeploymentClassLoader()));
        ObjectCloner parameterCloner = ObjectCloners.getSerializingObjectClonerFactory().createCloner(paramConfig);
        Method method = view.getMethod(invocation.getInvokedMethod().getName(), DescriptorUtils.methodDescriptor((Method)invocation.getInvokedMethod()));
        boolean async = view.isAsynchronous(method);
        if (invocation.getParameters() == null) {
            parameters = EMPTY_OBJECT_ARRAY;
        } else {
            parameters = new Object[invocation.getParameters().length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = this.clone(method.getParameterTypes()[i], parameterCloner, invocation.getParameters()[i], this.allowPassByReference);
            }
        }
        final InterceptorContext context = new InterceptorContext();
        context.setParameters(parameters);
        context.setMethod(method);
        context.setTarget(invocation.getInvokedProxy());
        context.setContextData(new HashMap());
        context.putPrivateData(Component.class, (Object)ejbComponent);
        context.putPrivateData(ComponentView.class, (Object)view);
        if (locator instanceof StatefulEJBLocator) {
            SessionID sessionID = ((StatefulEJBLocator)locator).getSessionId();
            context.putPrivateData(SessionID.class, (Object)sessionID);
        } else if (locator instanceof EntityEJBLocator) {
            Object primaryKey = ((EntityEJBLocator)locator).getPrimaryKey();
            context.putPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, primaryKey);
        }
        ClonerConfiguration config = new ClonerConfiguration();
        config.setClassCloner((ClassCloner)new LocalInvocationClassCloner(invocation.getInvokedProxy().getClass().getClassLoader()));
        ObjectCloner resultCloner = ObjectCloners.getSerializingObjectClonerFactory().createCloner(config);
        if (async) {
            if (!(ejbComponent instanceof SessionBeanComponent)) throw EjbLogger.EJB3_LOGGER.asyncInvocationOnlyApplicableForSessionBeans();
            SessionBeanComponent component = (SessionBeanComponent)ejbComponent;
            CancellationFlag flag = new CancellationFlag();
            final SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
            AsyncInvocationTask task = new AsyncInvocationTask(flag){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Object runInvocation() throws Exception {
                    LocalEjbReceiver.setSecurityContextOnAssociation(securityContext);
                    try {
                        Object object = view.invoke(context);
                        return object;
                    }
                    finally {
                        LocalEjbReceiver.clearSecurityContextOnAssociation();
                    }
                }
            };
            context.putPrivateData(CancellationFlag.class, (Object)flag);
            component.getAsynchronousExecutor().submit(task);
            receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new ImmediateResultProducer(task));
            return;
        }
        try {
            result = view.invoke(context);
        }
        catch (Exception e) {
            throw (Exception)this.clone(resultCloner, e);
        }
        Object clonedResult = this.clone(invocation.getInvokedMethod().getReturnType(), resultCloner, result, this.allowPassByReference);
        receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new ImmediateResultProducer(clonedResult));
    }

    protected <T> StatefulEJBLocator<T> openSession(EJBReceiverContext context, Class<T> viewType, String appName, String moduleName, String distinctName, String beanName) throws IllegalArgumentException {
        EjbDeploymentInformation ejbInfo = this.findBean(appName, moduleName, distinctName, beanName);
        EJBComponent component = ejbInfo.getEjbComponent();
        if (!(component instanceof StatefulSessionComponent)) {
            throw EjbLogger.EJB3_LOGGER.notStatefulSessionBean(beanName, appName, moduleName, distinctName);
        }
        StatefulSessionComponent statefulComponent = (StatefulSessionComponent)component;
        SessionID sessionID = statefulComponent.createSession();
        return new StatefulEJBLocator(viewType, appName, moduleName, beanName, distinctName, sessionID, statefulComponent.getCache().getStrictAffinity(), this.getNodeName());
    }

    private Object clone(Class<?> target, ObjectCloner cloner, Object object, boolean allowPassByReference) {
        if (object == null) {
            return null;
        }
        if (target.isPrimitive()) {
            return object;
        }
        if (allowPassByReference && target.isAssignableFrom(object.getClass())) {
            return object;
        }
        return this.clone(cloner, object);
    }

    private Object clone(ObjectCloner cloner, Object object) {
        if (object == null) {
            return null;
        }
        try {
            return cloner.clone(object);
        }
        catch (Exception e) {
            throw EjbLogger.EJB3_LOGGER.failedToMarshalEjbParameters(e);
        }
    }

    protected boolean exists(String appName, String moduleName, String distinctName, String beanName) {
        try {
            EjbDeploymentInformation ejbDeploymentInformation = this.findBean(appName, moduleName, distinctName, beanName);
            return ejbDeploymentInformation != null;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    protected int sendPrepare(EJBReceiverContext context, TransactionID transactionID) throws XAException {
        return 0;
    }

    protected void sendCommit(EJBReceiverContext context, TransactionID transactionID, boolean onePhase) throws XAException {
    }

    protected void sendRollback(EJBReceiverContext context, TransactionID transactionID) throws XAException {
    }

    protected void sendForget(EJBReceiverContext context, TransactionID transactionID) throws XAException {
    }

    protected void beforeCompletion(EJBReceiverContext context, TransactionID transactionID) {
    }

    private EjbDeploymentInformation findBean(String appName, String moduleName, String distinctName, String beanName) {
        ModuleDeployment module = ((DeploymentRepository)this.deploymentRepository.getValue()).getModules().get(new DeploymentModuleIdentifier(appName, moduleName, distinctName));
        if (module == null) {
            throw EjbLogger.EJB3_LOGGER.unknownDeployment(appName, moduleName, distinctName);
        }
        EjbDeploymentInformation ejbInfo = module.getEjbs().get(beanName);
        if (ejbInfo == null) {
            throw EjbLogger.EJB3_LOGGER.ejbNotFoundInDeployment(beanName, appName, moduleName, distinctName);
        }
        return ejbInfo;
    }

    public void start(StartContext context) throws StartException {
        ((DeploymentRepository)this.deploymentRepository.getValue()).addListener(this.deploymentListener);
        RegistryCollector clusters = (RegistryCollector)this.clusterRegistryCollector.getValue();
        clusters.addListener((RegistryCollector.Listener)this);
        for (Registry cluster : clusters.getRegistries()) {
            this.addClusterNodes(cluster.getName(), cluster.getEntries());
            ClusterTopologyUpdateListener clusterTopologyUpdateListener = new ClusterTopologyUpdateListener((Registry<String, List<ClientMapping>>)cluster);
            cluster.addListener((Registry.Listener)clusterTopologyUpdateListener);
            this.clusterTopologyUpdateListeners.add(clusterTopologyUpdateListener);
        }
    }

    public void stop(StopContext context) {
        for (EJBReceiverContext ctx : this.contexts) {
            ctx.close();
        }
        this.contexts.clear();
        ((DeploymentRepository)this.deploymentRepository.getValue()).removeListener(this.deploymentListener);
        RegistryCollector collector = (RegistryCollector)this.clusterRegistryCollector.getValue();
        collector.removeListener((RegistryCollector.Listener)this);
        for (ClusterTopologyUpdateListener clusterTopologyUpdateListener : this.clusterTopologyUpdateListeners) {
            clusterTopologyUpdateListener.unregisterListener();
        }
    }

    public LocalEjbReceiver getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<DeploymentRepository> getDeploymentRepository() {
        return this.deploymentRepository;
    }

    public void registryAdded(Registry<String, List<ClientMapping>> cluster) {
        String clusterName = cluster.getName();
        this.addClusterNodes(clusterName, cluster.getEntries());
        ClusterTopologyUpdateListener clusterTopologyUpdateListener = new ClusterTopologyUpdateListener(cluster);
        cluster.addListener((Registry.Listener)clusterTopologyUpdateListener);
        this.clusterTopologyUpdateListeners.add(clusterTopologyUpdateListener);
    }

    public void registryRemoved(Registry<String, List<ClientMapping>> registry) {
    }

    public Injector<RegistryCollector> getClusterRegistryCollectorInjector() {
        return this.clusterRegistryCollector;
    }

    private void addClusterNodes(String clusterName, Map<String, List<ClientMapping>> addedNodes) {
        if (addedNodes == null || addedNodes.isEmpty()) {
            return;
        }
        List<EJBReceiverContext> receiverContexts = this.contexts;
        for (EJBReceiverContext receiverContext : receiverContexts) {
            this.addClusterNodes(receiverContext.getClientContext(), clusterName, addedNodes);
        }
    }

    private void addClusterNodes(EJBClientContext ejbClientContext, String clusterName, Map<String, List<ClientMapping>> addedNodes) {
        if (addedNodes == null || addedNodes.isEmpty()) {
            return;
        }
        EJBRemoteConnectorService ejbRemoteConnectorService = this.ejbRemoteConnectorServiceValue.getOptionalValue();
        Endpoint endpoint = this.endpointValue.getOptionalValue();
        if (ejbRemoteConnectorService == null || endpoint == null) {
            return;
        }
        SocketBinding ejbRemoteConnectorSocketBinding = ejbRemoteConnectorService.getEJBRemoteConnectorSocketBinding();
        InetAddress bindAddress = ejbRemoteConnectorSocketBinding.getAddress();
        ClusterContext clusterContext = ejbClientContext.getOrCreateClusterContext(clusterName);
        for (Map.Entry<String, List<ClientMapping>> entry : addedNodes.entrySet()) {
            String addedNodeName = entry.getKey();
            if (this.getNodeName().equals(addedNodeName)) {
                clusterContext.addClusterNodes(new ClusterNodeManager[]{new LocalClusterNodeManager()});
                continue;
            }
            if (this.isLocalOnlyEJBClientContext(ejbClientContext)) {
                logger.debug((Object)("Skipping cluster node additions to EJB client context " + ejbClientContext + " since it can only handle local node"));
                continue;
            }
            List<ClientMapping> clientMappings = entry.getValue();
            ClientMapping resolvedClientMapping = null;
            for (ClientMapping clientMapping : clientMappings) {
                int netMask;
                InetAddress sourceNetworkAddress = clientMapping.getSourceNetworkAddress();
                boolean match = NetworkUtil.belongsToNetwork((InetAddress)bindAddress, (InetAddress)sourceNetworkAddress, (byte)((byte)((netMask = clientMapping.getSourceNetworkMaskBits()) & 0xFF)));
                if (!match) continue;
                resolvedClientMapping = clientMapping;
                logger.debug((Object)("Client mapping " + clientMapping + " matches client address " + bindAddress));
                break;
            }
            if (resolvedClientMapping == null) {
                EjbLogger.ROOT_LOGGER.cannotAddClusterNodeDueToUnresolvableClientMapping(addedNodeName, clusterName, bindAddress);
                continue;
            }
            RemotingConnectionClusterNodeManager remotingClusterNodeManager = new RemotingConnectionClusterNodeManager(clusterContext, endpoint, addedNodeName, resolvedClientMapping.getDestinationAddress(), resolvedClientMapping.getDestinationPort());
            clusterContext.addClusterNodes(new ClusterNodeManager[]{remotingClusterNodeManager});
        }
    }

    private boolean isLocalOnlyEJBClientContext(EJBClientContext ejbClientContext) {
        EJBClientConfiguration clientConfiguration = ejbClientContext.getEJBClientConfiguration();
        return clientConfiguration instanceof DefaultEjbClientContextService.LocalOnlyEjbClientConfiguration;
    }

    private static void setSecurityContextOnAssociation(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    private static void clearSecurityContextOnAssociation() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }

    private class ClusterTopologyUpdateListener
    implements Registry.Listener<String, List<ClientMapping>> {
        private final Registry<String, List<ClientMapping>> cluster;

        ClusterTopologyUpdateListener(Registry<String, List<ClientMapping>> cluster) {
            this.cluster = cluster;
        }

        public void addedEntries(Map<String, List<ClientMapping>> addedNodes) {
            LocalEjbReceiver.this.addClusterNodes(this.cluster.getName(), addedNodes);
        }

        public void updatedEntries(Map<String, List<ClientMapping>> updated) {
        }

        public void removedEntries(Set<String> removedNodes) {
            List receiverContexts = LocalEjbReceiver.this.contexts;
            for (EJBReceiverContext receiverContext : receiverContexts) {
                ClusterContext clusterContext = receiverContext.getClientContext().getClusterContext(this.cluster.getName());
                if (clusterContext == null) continue;
                for (String removedNodeName : removedNodes) {
                    clusterContext.removeClusterNode(removedNodeName);
                }
            }
        }

        private void unregisterListener() {
            this.cluster.removeListener((Registry.Listener)this);
        }
    }

    private class LocalClusterNodeManager
    implements ClusterNodeManager {
        private LocalClusterNodeManager() {
        }

        public String getNodeName() {
            return LocalEjbReceiver.this.getNodeName();
        }

        public EJBReceiver getEJBReceiver() {
            return LocalEjbReceiver.this;
        }
    }

    private class Listener
    implements DeploymentRepositoryListener {
        private Listener() {
        }

        @Override
        public void listenerAdded(DeploymentRepository repository) {
            for (Map.Entry<DeploymentModuleIdentifier, ModuleDeployment> entry : repository.getModules().entrySet()) {
                DeploymentModuleIdentifier module = entry.getKey();
                LocalEjbReceiver.this.registerModule(module.getApplicationName(), module.getModuleName(), module.getDistinctName());
            }
        }

        @Override
        public void deploymentAvailable(DeploymentModuleIdentifier deployment, ModuleDeployment moduleDeployment) {
            LocalEjbReceiver.this.registerModule(deployment.getApplicationName(), deployment.getModuleName(), deployment.getDistinctName());
        }

        @Override
        public void deploymentRemoved(DeploymentModuleIdentifier deployment) {
            LocalEjbReceiver.this.deregisterModule(deployment.getApplicationName(), deployment.getModuleName(), deployment.getDistinctName());
        }
    }

    private static class ImmediateResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final Object clonedResult;

        public ImmediateResultProducer(Object clonedResult) {
            this.clonedResult = clonedResult;
        }

        public Object getResult() throws Exception {
            return this.clonedResult;
        }

        public void discardResult() {
        }
    }
}

