/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.Closeable;
import java.io.IOException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.xnio.IoUtils;

abstract class UserTransactionManagementTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(UserTransactionManagementTask.class);
    protected final short invocationId;
    protected final ChannelAssociation channelAssociation;
    protected final EJBRemoteTransactionsRepository transactionsRepository;
    protected final UserTransactionID userTransactionID;
    protected final MarshallerFactory marshallerFactory;
    protected final TransactionRequestHandler transactionRequestHandler;

    UserTransactionManagementTask(TransactionRequestHandler transactionRequestHandler, EJBRemoteTransactionsRepository transactionsRepository, MarshallerFactory marshallerFactory, UserTransactionID userTransactionID, ChannelAssociation channelAssociation, short invocationId) {
        this.transactionRequestHandler = transactionRequestHandler;
        this.channelAssociation = channelAssociation;
        this.marshallerFactory = marshallerFactory;
        this.invocationId = invocationId;
        this.transactionsRepository = transactionsRepository;
        this.userTransactionID = userTransactionID;
    }

    @Override
    public final void run() {
        try {
            this.manageTransaction();
        }
        catch (Throwable t) {
            try {
                this.transactionRequestHandler.writeException(this.channelAssociation, this.marshallerFactory, this.invocationId, t, null);
            }
            catch (IOException e) {
                logger.error((Object)"Could not write out message to channel due to", (Throwable)e);
                IoUtils.safeClose((Closeable)this.channelAssociation.getChannel());
            }
            return;
        }
        try {
            this.transactionRequestHandler.writeTxInvocationResponseMessage(this.channelAssociation, this.invocationId);
        }
        catch (IOException e) {
            logger.error((Object)"Could not write out invocation success message to channel due to", (Throwable)e);
            IoUtils.safeClose((Closeable)this.channelAssociation.getChannel());
        }
    }

    protected abstract void manageTransaction() throws Throwable;

    protected void resumeTransaction(Transaction transaction) throws Exception {
        TransactionManager transactionManager = this.transactionsRepository.getTransactionManager();
        transactionManager.resume(transaction);
    }
}

