/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.net.InetSocketAddress;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ProcessControllerConnectionService;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.server.services.net.NetworkInterfaceBinding;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class ServerInventoryService
implements Service<ServerInventory> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "server-inventory"});
    private final InjectedValue<NetworkInterfaceBinding> iFace = new InjectedValue();
    private final InjectedValue<ProcessControllerConnectionService> client = new InjectedValue();
    private final HostControllerEnvironment environment;
    private final int port;
    private ServerInventory serverInventory;

    ServerInventoryService(HostControllerEnvironment environment, int port) {
        this.environment = environment;
        this.port = port;
    }

    public synchronized void start(StartContext context) throws StartException {
        ServerInventory serverInventory;
        log.debug((Object)"Starting Host Controller Server Inventory");
        try {
            NetworkInterfaceBinding interfaceBinding = (NetworkInterfaceBinding)this.iFace.getValue();
            ProcessControllerClient client = ((ProcessControllerConnectionService)this.client.getValue()).getClient();
            InetSocketAddress binding = new InetSocketAddress(interfaceBinding.getAddress(), this.port);
            serverInventory = new ServerInventory(this.environment, binding, client);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        this.serverInventory = serverInventory;
        ((ProcessControllerConnectionService)this.client.getValue()).setServerInventory(serverInventory);
    }

    public synchronized void stop(StopContext context) {
        this.serverInventory = null;
        ((ProcessControllerConnectionService)this.client.getValue()).setServerInventory(null);
    }

    public synchronized ServerInventory getValue() throws IllegalStateException, IllegalArgumentException {
        ServerInventory serverInventory = this.serverInventory;
        if (serverInventory == null) {
            throw new IllegalStateException();
        }
        return serverInventory;
    }

    InjectedValue<NetworkInterfaceBinding> getInterface() {
        return this.iFace;
    }

    InjectedValue<ProcessControllerConnectionService> getClient() {
        return this.client;
    }
}

