/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.descriptions.common.ManagementDescription;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostRootDescription {
    private static final String RESOURCE_NAME = HostRootDescription.class.getPackage().getName() + ".LocalDescriptions";
    private static final String DOMAIN_CONTROLLER = "domain-controller";
    private static final String SERVER_CONFIG = "server-config";

    public static ModelNode getDescription(Locale locale) {
        ResourceBundle bundle = HostRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("host"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        root.get(new String[]{"attributes", "namespaces"}).set(CommonDescriptions.getNamespacePrefixAttribute((Locale)locale));
        root.get(new String[]{"attributes", "schema-locations"}).set(CommonDescriptions.getSchemaLocationAttribute((Locale)locale));
        root.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("host.name"));
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "required"}).set(false);
        root.get(new String[]{"attributes", "name", "nillable"}).set(true);
        root.get(new String[]{"attributes", "name", "min-length"}).set(1);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "description"}).set(bundle.getString("host.domain-controller"));
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "type"}).set(ModelType.OBJECT);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "required"}).set(true);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "head-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "tail-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "local", "type"}).set(ModelType.OBJECT);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "local", "description"}).set(bundle.getString("host.domain-controller.local"));
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "local", "required"}).set(false);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "remote", "type"}).set(ModelType.OBJECT);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "remote", "description"}).set(bundle.getString("host.domain-controller.remote"));
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "remote", "value-type", "host", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "remote", "value-type", "host", "description"}).set(bundle.getString("host.domain-controller.remote.host"));
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "remote", "value-type", "host", "required"}).set(true);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "remote", "value-type", "port", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "remote", "value-type", "port", "description"}).set(bundle.getString("host.domain-controller.remote.port"));
        root.get(new String[]{"attributes", DOMAIN_CONTROLLER, "value-type", "remote", "value-type", "port", "required"}).set(true);
        root.get("operations").setEmptyObject();
        root.get(new String[]{"children", "extension", "description"}).set(bundle.getString("host.extension"));
        root.get(new String[]{"children", "extension", "min-occurs"}).set(0);
        root.get(new String[]{"children", "extension", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "extension", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "path", "description"}).set(bundle.getString("host.path"));
        root.get(new String[]{"children", "path", "min-occurs"}).set(0);
        root.get(new String[]{"children", "path", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "path", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "system-property", "description"}).set(bundle.getString("host.system-properties"));
        root.get(new String[]{"children", "system-property", "min-occurs"}).set(0);
        root.get(new String[]{"children", "system-property", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "system-property", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "native-interface"}).set(ManagementDescription.getNativeManagementDescription((Locale)locale));
        root.get(new String[]{"children", "http-interface"}).set(ManagementDescription.getHttpManagementDescription((Locale)locale));
        root.get(new String[]{"children", "interface", "description"}).set(bundle.getString("host.interface"));
        root.get(new String[]{"children", "interface", "min-occurs"}).set(0);
        root.get(new String[]{"children", "interface", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "interface", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "jvm", "description"}).set(bundle.getString("host.jvm"));
        root.get(new String[]{"children", "jvm", "min-occurs"}).set(0);
        root.get(new String[]{"children", "jvm", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "jvm", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", SERVER_CONFIG, "description"}).set(bundle.getString("host.server-config"));
        root.get(new String[]{"children", SERVER_CONFIG, "min-occurs"}).set(0);
        root.get(new String[]{"children", SERVER_CONFIG, "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", SERVER_CONFIG, "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "server", "description"}).set(bundle.getString("host.server"));
        root.get(new String[]{"children", "server", "min-occurs"}).set(0);
        root.get(new String[]{"children", "server", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "server", "model-description"}).setEmptyObject();
        return root;
    }

    public static ModelNode getStartServerOperation(Locale locale) {
        ResourceBundle bundle = HostRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("start-server");
        root.get("description").set(bundle.getString("host.start-server"));
        root.get(new String[]{"request-properties", "server", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "server", "description"}).set(bundle.getString("host.start-server.server"));
        root.get(new String[]{"request-properties", "server", "required"}).set(true);
        root.get(new String[]{"request-properties", "server", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "server", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        root.get(new String[]{"reply-properties", "description"}).set(bundle.getString("host.start-server.reply"));
        return root;
    }

    public static ModelNode getRestartServerOperation(Locale locale) {
        ResourceBundle bundle = HostRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("restart-server");
        root.get("description").set(bundle.getString("host.restart-server"));
        root.get(new String[]{"request-properties", "server", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "server", "description"}).set(bundle.getString("host.restart-server.server"));
        root.get(new String[]{"request-properties", "server", "required"}).set(true);
        root.get(new String[]{"request-properties", "server", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "server", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        root.get(new String[]{"reply-properties", "description"}).set(bundle.getString("host.restart-server.reply"));
        return root;
    }

    public static ModelNode getStopServerOperation(Locale locale) {
        ResourceBundle bundle = HostRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("stop-server");
        root.get("description").set(bundle.getString("host.stop-server"));
        root.get(new String[]{"request-properties", "server", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "server", "description"}).set(bundle.getString("host.stop-server.server"));
        root.get(new String[]{"request-properties", "server", "required"}).set(true);
        root.get(new String[]{"request-properties", "server", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "server", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        root.get(new String[]{"reply-properties", "description"}).set(bundle.getString("host.stop-server.reply"));
        return root;
    }

    public static ModelNode getSystemPropertiesDescription(Locale locale) {
        ResourceBundle bundle = HostRootDescription.getResourceBundle(locale);
        return CommonDescriptions.getSystemPropertyDescription((Locale)locale, (String)bundle.getString("host.system-property"), (boolean)true);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

