/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.ModelControllerOperationHandler;
import org.jboss.as.controller.remote.ModelControllerOperationHandlerService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.mgmt.ManagementCommunicationService;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerImpl;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;

public class DomainControllerOperationHandlerService
extends ModelControllerOperationHandlerService {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");
    public static final ServiceName SERVICE_NAME = DomainController.SERVICE_NAME.append(ModelControllerOperationHandlerService.OPERATION_HANDLER_NAME_SUFFIX);
    private InjectedValue<ManagementCommunicationService> managementCommunicationService = new InjectedValue();
    private final boolean isSlave;

    public DomainControllerOperationHandlerService(boolean isSlave) {
        this.isSlave = isSlave;
    }

    public void start(StartContext context) throws StartException {
        log.info((Object)"Starting Domain Controller Operation Handler");
        super.start(context);
        ((ManagementCommunicationService)this.managementCommunicationService.getValue()).addHandler((ManagementOperationHandler)this.getValue());
    }

    public void stop(StartContext context) {
        ((ManagementCommunicationService)this.managementCommunicationService.getValue()).removeHandler((ManagementOperationHandler)this.getValue());
    }

    public InjectedValue<ManagementCommunicationService> getManagementCommunicationServiceValue() {
        return this.managementCommunicationService;
    }

    protected MessageHandler getInitialMessageHandler() {
        return ((ManagementCommunicationService)this.managementCommunicationService.getValue()).getInitialMessageHandler();
    }

    protected ModelControllerOperationHandler createOperationHandler(ModelController modelController, MessageHandler initialMessageHandler) {
        if (this.isSlave) {
            return super.createOperationHandler(modelController, initialMessageHandler);
        }
        return new MasterDomainControllerOperationHandlerImpl((DomainController)modelController, initialMessageHandler);
    }
}

