/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.ModelControllerOperationHandlerImpl;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerSlaveClient;
import org.jboss.as.host.controller.mgmt.RemoteDomainControllerSlaveClient;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.SimpleByteDataInput;
import org.jboss.as.protocol.SimpleByteDataOutput;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class MasterDomainControllerOperationHandlerImpl
extends ModelControllerOperationHandlerImpl {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller");

    public MasterDomainControllerOperationHandlerImpl(DomainController modelController, MessageHandler initiatingHandler) {
        super((ModelController)modelController, initiatingHandler);
    }

    protected DomainController getController() {
        return (DomainController)super.getController();
    }

    public ManagementResponse operationFor(byte commandByte) {
        switch (commandByte) {
            case 81: {
                return new RegisterOperation();
            }
            case 83: {
                return new UnregisterOperation();
            }
            case 85: {
                return new GetFileOperation();
            }
        }
        return super.operationFor(commandByte);
    }

    private class GetFileOperation
    extends RegistryOperation {
        private File localPath;

        private GetFileOperation() {
        }

        protected final byte getResponseCode() {
            return 86;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        protected void readRequest(InputStream inputStream) throws IOException {
            localFileRepository = MasterDomainControllerOperationHandlerImpl.this.getController().getFileRepository();
            input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)36);
                rootId = input.readByte();
                ProtocolUtils.expectHeader((DataInput)input, (int)37);
                filePath = input.readUTF();
                switch (rootId) {
                    case 38: {
                        this.localPath = localFileRepository.getFile(filePath);
                        ** break;
                    }
                    case 39: {
                        this.localPath = localFileRepository.getConfigurationFile(filePath);
                        ** break;
                    }
                    case 40: {
                        hash = HashUtil.hexStringToByteArray((String)filePath);
                        this.localPath = localFileRepository.getDeploymentRoot(hash);
                        ** break;
                    }
                    default: {
                        throw new IOException(String.format("Invalid root id [%d]", new Object[]{rootId}));
lbl22:
                        // 3 sources

                    }
                }
            }
            catch (Throwable var7_7) {
                StreamUtils.safeClose(input);
                throw var7_7;
            }
            StreamUtils.safeClose((Closeable)input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendResponse(OutputStream outputStream) throws IOException {
            SimpleByteDataOutput output = null;
            try {
                output = new SimpleByteDataOutput(outputStream);
                output.writeByte(41);
                if (this.localPath == null || !this.localPath.exists()) {
                    output.writeInt(-1);
                } else if (this.localPath.isFile()) {
                    output.writeInt(1);
                    this.writeFile(this.localPath, (DataOutput)output);
                } else {
                    List<File> childFiles = this.getChildFiles(this.localPath);
                    output.writeInt(childFiles.size());
                    for (File child : childFiles) {
                        this.writeFile(child, (DataOutput)output);
                    }
                }
                output.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(output);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)output);
        }

        private List<File> getChildFiles(File base) {
            ArrayList<File> childFiles = new ArrayList<File>();
            this.getChildFiles(base, childFiles);
            return childFiles;
        }

        private void getChildFiles(File base, List<File> childFiles) {
            for (File child : base.listFiles()) {
                if (child.isFile()) {
                    childFiles.add(child);
                    continue;
                }
                this.getChildFiles(child, childFiles);
            }
        }

        private String getRelativePath(File parent, File child) {
            return child.getAbsolutePath().substring(parent.getAbsolutePath().length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(File file, DataOutput output) throws IOException {
            output.writeByte(48);
            output.writeByte(37);
            output.writeUTF(this.getRelativePath(this.localPath, file));
            output.writeByte(49);
            output.writeLong(file.length());
            FileInputStream inputStream = null;
            try {
                int len;
                inputStream = new FileInputStream(file);
                byte[] buffer = new byte[8192];
                while ((len = ((InputStream)inputStream).read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException ignored) {}
                }
            }
            output.writeByte(50);
        }
    }

    private class UnregisterOperation
    extends RegistryOperation {
        private UnregisterOperation() {
        }

        protected final byte getResponseCode() {
            return 84;
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            MasterDomainControllerOperationHandlerImpl.this.getController().removeClient(this.hostId);
        }
    }

    private class RegisterOperation
    extends RegistryOperation {
        InetAddress slaveAddress;
        int slavePort;

        private RegisterOperation() {
        }

        protected final byte getResponseCode() {
            return 82;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readRequest(InputStream inputStream) throws IOException {
            SimpleByteDataInput input = null;
            try {
                input = new SimpleByteDataInput(inputStream);
                ProtocolUtils.expectHeader((DataInput)input, (int)32);
                this.hostId = input.readUTF();
                ProtocolUtils.expectHeader((DataInput)input, (int)33);
                int addressSize = input.readInt();
                byte[] addressBytes = new byte[addressSize];
                input.readFully(addressBytes);
                ProtocolUtils.expectHeader((DataInput)input, (int)34);
                this.slavePort = input.readInt();
                this.slaveAddress = InetAddress.getByAddress(addressBytes);
                input.close();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)input);
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            ModelNode node;
            try {
                MasterDomainControllerOperationHandlerImpl.this.getController().addClient((DomainControllerSlaveClient)new RemoteDomainControllerSlaveClient(this.hostId, this.slaveAddress, this.slavePort));
                node = MasterDomainControllerOperationHandlerImpl.this.getController().getDomainModel();
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                node = new ModelNode();
                node.get("protocol-error").set(e.getMessage());
            }
            outputStream.write(35);
            node.writeExternal(outputStream);
        }
    }

    private abstract class RegistryOperation
    extends ManagementResponse {
        String hostId;

        RegistryOperation() {
            super(MasterDomainControllerOperationHandlerImpl.this.getInitiatingHandler());
        }

        protected void readRequest(InputStream inputStream) throws IOException {
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)32);
            this.hostId = StreamUtils.readUTFZBytes((InputStream)inputStream);
        }
    }
}

