/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.host.controller.descriptions.HostServerDescription;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final ServerAddHandler INSTANCE = new ServerAddHandler();
    private final ParametersValidator validator = new ParametersValidator();

    public static ModelNode getAddServerOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("group").set(existing.get("group"));
        op.get("auto-start").set(existing.get("auto-start"));
        if (existing.hasDefined("socket-binding-group")) {
            op.get("socket-binding-group").set(existing.get("socket-binding-group"));
        }
        if (existing.hasDefined("socket-binding-port-offset")) {
            op.get("socket-binding-port-offset").set(existing.get("socket-binding-port-offset"));
        }
        return op;
    }

    private ServerAddHandler() {
        this.validator.registerValidator("group", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true));
        this.validator.registerValidator("socket-binding-group", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true));
        this.validator.registerValidator("socket-binding-port-offset", (ParameterValidator)new IntRangeValidator(0, 65535, true, true));
        this.validator.registerValidator("auto-start", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true, true));
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        this.validator.validate(operation);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        this.createCoreModel(model);
        model.get("name").set(name);
        model.get("group").set(operation.require("group"));
        if (operation.hasDefined("socket-binding-group")) {
            model.get("socket-binding-group").set(operation.get("socket-binding-group"));
        }
        if (operation.hasDefined("socket-binding-port-offset")) {
            model.get("socket-binding-port-offset").set(operation.get("socket-binding-port-offset"));
        }
        ModelNode autoStart = operation.hasDefined("auto-start") ? operation.get("auto-start") : new ModelNode().set(true);
        model.get("auto-start").set(autoStart);
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)operation.get("address"));
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensating);
    }

    private void createCoreModel(ModelNode root) {
        root.get("path");
        root.get("system-property");
        root.get("interface");
        root.get("jvm");
        root.get("socket-binding-group");
        root.get("socket-binding-port-offset");
    }

    public ModelNode getModelDescription(Locale locale) {
        return HostServerDescription.getServerAddOperation(locale);
    }
}

