/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.dmr.ModelNode;

public class OperationRouting {
    private final String singleHost;
    private final Set<String> hosts = new HashSet<String>();
    private final boolean twoStep;

    public static OperationRouting determineRouting(ModelNode operation, LocalHostControllerInfo localHostControllerInfo, ImmutableManagementResourceRegistration registry) throws OperationFailedException {
        Set flags;
        OperationRouting.checkNull(operation, registry);
        OperationRouting routing = null;
        String targetHost = null;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String operationName = operation.get("operation").asString();
        boolean compositeOp = false;
        if (address.size() > 0) {
            PathElement first = address.getElement(0);
            if ("host".equals(first.getKey())) {
                targetHost = first.getValue();
            }
        } else {
            compositeOp = "composite".equals(operationName);
        }
        if (targetHost != null) {
            PathElement first;
            flags = registry.getOperationFlags(PathAddress.EMPTY_ADDRESS, operationName);
            OperationRouting.checkNull(operation, flags);
            if (flags.contains(OperationEntry.Flag.READ_ONLY) && !flags.contains(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS)) {
                routing = new OperationRouting(targetHost, false);
            } else if (address.size() > 1 && "server".equals((first = address.getElement(1)).getKey())) {
                routing = new OperationRouting(targetHost, false);
            }
            if (routing == null) {
                routing = flags.contains(OperationEntry.Flag.HOST_CONTROLLER_ONLY) ? new OperationRouting(targetHost, false) : new OperationRouting(targetHost, true);
            }
        } else if (compositeOp) {
            if (operation.hasDefined("steps")) {
                HashSet<String> allHosts = new HashSet<String>();
                boolean twoStep = false;
                for (ModelNode step : operation.get("steps").asList()) {
                    ImmutableManagementResourceRegistration stepRegistry;
                    OperationRouting stepRouting = OperationRouting.determineRouting(step, localHostControllerInfo, stepRegistry = registry.getSubModel(PathAddress.pathAddress((ModelNode)step.get("address"))));
                    if (stepRouting.isTwoStep()) {
                        twoStep = true;
                    }
                    allHosts.addAll(stepRouting.getHosts());
                }
                routing = new OperationRouting(allHosts);
            } else {
                routing = new OperationRouting(localHostControllerInfo.getLocalHostName(), false);
            }
        } else {
            flags = registry.getOperationFlags(PathAddress.EMPTY_ADDRESS, operationName);
            OperationRouting.checkNull(operation, flags);
            if (flags.contains(OperationEntry.Flag.READ_ONLY) && !flags.contains(OperationEntry.Flag.DOMAIN_PUSH_TO_SERVERS)) {
                routing = new OperationRouting(localHostControllerInfo.getLocalHostName(), false);
            } else if (!localHostControllerInfo.isMasterDomainController()) {
                routing = new OperationRouting();
            } else if (flags.contains(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY)) {
                routing = new OperationRouting(localHostControllerInfo.getLocalHostName(), false);
            }
        }
        if (routing == null) {
            routing = new OperationRouting(true);
        }
        return routing;
    }

    private static void checkNull(ModelNode operation, Object toCheck) throws OperationFailedException {
        if (toCheck == null) {
            throw new OperationFailedException(new ModelNode().set(DomainControllerMessages.MESSAGES.noHandlerForOperation(operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.get("address")))));
        }
    }

    private OperationRouting() {
        this.twoStep = false;
        this.singleHost = null;
    }

    private OperationRouting(boolean twoStep) {
        this.twoStep = twoStep;
        this.singleHost = null;
    }

    public OperationRouting(String host, boolean twoStep) {
        this.hosts.add(host);
        this.twoStep = twoStep;
        this.singleHost = host;
    }

    public OperationRouting(Collection<String> hosts) {
        this.hosts.addAll(hosts);
        this.twoStep = true;
        this.singleHost = null;
    }

    public Set<String> getHosts() {
        return this.hosts;
    }

    public String getSingleHost() {
        return this.singleHost;
    }

    public boolean isTwoStep() {
        return this.twoStep;
    }

    public boolean isLocalOnly(String localHostName) {
        if (this.singleHost != null) {
            return localHostName.equals(this.singleHost);
        }
        return this.hosts.size() == 1 && this.hosts.contains(localHostName);
    }

    public boolean isLocalCallNeeded(String localHostName) {
        return localHostName.equals(this.singleHost) || this.hosts.size() == 0 || this.hosts.contains(localHostName);
    }
}

