/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandler;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerImpl;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;

public class MasterDomainControllerOperationHandlerService
extends AbstractModelControllerOperationHandlerFactoryService {
    public static final ServiceName SERVICE_NAME = DomainController.SERVICE_NAME.append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
    private final DomainController domainController;
    private final HostControllerRegistrationHandler.OperationExecutor operationExecutor;

    public MasterDomainControllerOperationHandlerService(DomainController domainController, HostControllerRegistrationHandler.OperationExecutor operationExecutor) {
        this.domainController = domainController;
        this.operationExecutor = operationExecutor;
    }

    protected String getThreadGroupName() {
        return "domain-mgmt-handler-thread";
    }

    public HandleableCloseable.Key startReceiving(Channel channel) {
        final ManagementChannelHandler handler = new ManagementChannelHandler(ManagementClientChannelStrategy.create((Channel)channel), this.getExecutor());
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new HostControllerRegistrationHandler(handler, this.domainController, this.operationExecutor));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new ModelControllerClientOperationHandler(this.getController(), (ManagementChannelAssociation)handler));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new MasterDomainControllerOperationHandlerImpl(this.domainController));
        HandleableCloseable.Key key = channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleClose(Channel closed, IOException exception) {
                handler.shutdown();
                boolean interrupted = false;
                try {
                    if (!handler.awaitCompletion((long)CHANNEL_SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                        HostControllerLogger.ROOT_LOGGER.gracefulManagementChannelHandlerShutdownTimedOut(CHANNEL_SHUTDOWN_TIMEOUT);
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    HostControllerLogger.ROOT_LOGGER.serviceShutdownIncomplete(e);
                }
                catch (Exception e) {
                    HostControllerLogger.ROOT_LOGGER.serviceShutdownIncomplete(e);
                }
                finally {
                    handler.shutdownNow();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        channel.receiveMessage(handler.getReceiver());
        return key;
    }
}

