/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementChannelReceiver;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.RemoteFileRequestAndHandler;
import org.jboss.as.server.mgmt.domain.ServerToHostRemoteFileRequestAndHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.MessageOutputStream;

public class ServerToHostOperationHandlerFactoryService
implements ManagementChannelInitialization,
Service<ManagementChannelInitialization> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"management", "server", "to", "host", "controller"});
    private final ExecutorService executorService;
    private final InjectedValue<ServerInventory> serverInventory = new InjectedValue();
    private final DeploymentFileRepository deploymentFileRepository;

    private ServerToHostOperationHandlerFactoryService(ExecutorService executorService, DeploymentFileRepository deploymentFileRepository) {
        this.executorService = executorService;
        this.deploymentFileRepository = deploymentFileRepository;
    }

    public static void install(ServiceTarget serviceTarget, ServiceName serverInventoryName, ExecutorService executorService, DeploymentFileRepository deploymentFileRepository) {
        ServerToHostOperationHandlerFactoryService serverToHost = new ServerToHostOperationHandlerFactoryService(executorService, deploymentFileRepository);
        serviceTarget.addService(SERVICE_NAME, (Service)serverToHost).addDependency(serverInventoryName, ServerInventory.class, serverToHost.serverInventory).install();
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public ManagementChannelInitialization getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public HandleableCloseable.Key startReceiving(Channel channel) {
        InitialMessageHandler receiver = new InitialMessageHandler();
        channel.receiveMessage((Channel.Receiver)receiver);
        return null;
    }

    protected static void safeWriteResponse(Channel channel, ManagementProtocolHeader header, Exception error) {
        if (header.getType() == 2) {
            try {
                ServerToHostOperationHandlerFactoryService.writeResponse(channel, (ManagementRequestHeader)header, error);
            }
            catch (IOException ioe) {
                ProtocolLogger.ROOT_LOGGER.tracef((Throwable)ioe, "failed to write error response for %s on channel: %s", (Object)header, (Object)channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeResponse(Channel channel, ManagementRequestHeader header, Exception error) throws IOException {
        ManagementResponseHeader response = ManagementResponseHeader.create((ManagementRequestHeader)header, (Exception)error);
        MessageOutputStream output = channel.writeMessage();
        try {
            ServerToHostOperationHandlerFactoryService.writeHeader((ManagementProtocolHeader)response, (OutputStream)output);
            output.write(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    protected static void safeWriteResponse(Channel channel, ManagementProtocolHeader header, byte param) {
        if (header.getType() == 2) {
            try {
                ServerToHostOperationHandlerFactoryService.writeResponse(channel, (ManagementRequestHeader)header, param);
            }
            catch (IOException ioe) {
                ProtocolLogger.ROOT_LOGGER.tracef((Throwable)ioe, "failed to write error response for %s on channel: %s", (Object)header, (Object)channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeResponse(Channel channel, ManagementRequestHeader header, byte param) throws IOException {
        ManagementResponseHeader response = ManagementResponseHeader.create((ManagementRequestHeader)header);
        MessageOutputStream output = channel.writeMessage();
        try {
            ServerToHostOperationHandlerFactoryService.writeHeader((ManagementProtocolHeader)response, (OutputStream)output);
            output.write((int)param);
            output.write(36);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    protected static void writeHeader(ManagementProtocolHeader header, OutputStream os) throws IOException {
        FlushableDataOutput output = org.jboss.as.protocol.mgmt.ProtocolUtils.wrapAsDataOutput((OutputStream)os);
        header.write((DataOutput)output);
    }

    private class ServerStartedHandler
    implements ManagementRequestHandler<Void, ServerInventory> {
        private final String serverProcessName;

        private ServerStartedHandler(String serverProcessName) {
            this.serverProcessName = serverProcessName;
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<ServerInventory> context) throws IOException {
            final byte param = input.readByte();
            String message = input.readUTF();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ServerInventory>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<ServerInventory> serverInventoryManagementRequestContext) throws Exception {
                    try {
                        ServerInventory inventory = (ServerInventory)context.getAttachment();
                        if (param == 33) {
                            inventory.serverStarted(ServerStartedHandler.this.serverProcessName);
                        } else {
                            inventory.serverStartFailed(ServerStartedHandler.this.serverProcessName);
                        }
                    }
                    finally {
                        resultHandler.done(null);
                    }
                }
            });
        }
    }

    private class GetFileOperation
    implements ManagementRequestHandler<ModelNode, Void> {
        private GetFileOperation() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            RemoteFileRequestAndHandler.RootFileReader reader = new RemoteFileRequestAndHandler.RootFileReader(){

                public File readRootFile(byte rootId, String filePath) throws RequestProcessingException {
                    byte[] hash = HashUtil.hexStringToByteArray((String)filePath);
                    return ServerToHostOperationHandlerFactoryService.this.deploymentFileRepository.getDeploymentRoot(hash);
                }
            };
            ServerToHostRemoteFileRequestAndHandler.INSTANCE.handleRequest(input, reader, context);
        }
    }

    private class InitialMessageHandler
    extends ManagementChannelReceiver {
        private InitialMessageHandler() {
        }

        public void handleMessage(Channel channel, DataInput input, ManagementProtocolHeader header) throws IOException {
            byte type = header.getType();
            if (type == 2) {
                ManagementRequestHeader request = (ManagementRequestHeader)header;
                this.handleMessage(channel, input, request);
            } else {
                ServerToHostOperationHandlerFactoryService.safeWriteResponse(channel, header, HostControllerMessages.MESSAGES.unrecognizedType(type));
                channel.close();
            }
        }

        public void handleMessage(final Channel channel, DataInput input, final ManagementRequestHeader header) throws IOException {
            final ServerInventory inventory = (ServerInventory)ServerToHostOperationHandlerFactoryService.this.serverInventory.getValue();
            byte type = header.getOperationId();
            if (type == 0) {
                ProtocolUtils.expectHeader((DataInput)input, (int)1);
                final String serverName = input.readUTF();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        HostControllerLogger.CONTROLLER_MANAGEMENT_LOGGER.serverRegistered(serverName, channel);
                        ManagementChannelHandler handler = new ManagementChannelHandler(channel, ServerToHostOperationHandlerFactoryService.this.executorService, new ManagementRequestHandlerFactory[]{new ServerHandlerFactory(serverName)});
                        inventory.serverCommunicationRegistered(serverName, handler);
                        ServerToHostOperationHandlerFactoryService.safeWriteResponse(channel, (ManagementProtocolHeader)header, null);
                        channel.receiveMessage(handler.getReceiver());
                    }
                };
                ServerToHostOperationHandlerFactoryService.this.executorService.execute(task);
            } else if (type == 3) {
                ProtocolUtils.expectHeader((DataInput)input, (int)1);
                final String serverName = input.readUTF();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        HostControllerLogger.CONTROLLER_MANAGEMENT_LOGGER.serverRegistered(serverName, channel);
                        ManagementChannelHandler handler = new ManagementChannelHandler(channel, ServerToHostOperationHandlerFactoryService.this.executorService, new ManagementRequestHandlerFactory[]{new ServerHandlerFactory(serverName)});
                        byte param = inventory.serverReconnected(serverName, handler) ? (byte)33 : 34;
                        ServerToHostOperationHandlerFactoryService.safeWriteResponse(channel, (ManagementProtocolHeader)header, param);
                        channel.receiveMessage(handler.getReceiver());
                    }
                };
                ServerToHostOperationHandlerFactoryService.this.executorService.execute(task);
            } else {
                ServerToHostOperationHandlerFactoryService.safeWriteResponse(channel, (ManagementProtocolHeader)header, HostControllerMessages.MESSAGES.unrecognizedType(type));
                channel.close();
            }
        }

        protected Channel.Receiver next() {
            return null;
        }
    }

    private class ServerHandlerFactory
    implements ManagementRequestHandlerFactory {
        private final String serverProcessName;

        private ServerHandlerFactory(String serverProcessName) {
            this.serverProcessName = serverProcessName;
        }

        public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
            byte operationId = header.getOperationId();
            switch (operationId) {
                case 36: {
                    handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                    return new GetFileOperation();
                }
                case 2: {
                    handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), ServerToHostOperationHandlerFactoryService.this.serverInventory.getValue());
                    return new ServerStartedHandler(this.serverProcessName);
                }
            }
            return handlers.resolveNext();
        }
    }
}

