/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;

public class HandlerEnable
implements ModelUpdateOperationHandler {
    static final HandlerEnable INSTANCE = new HandlerEnable();

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("disable");
        compensatingOperation.get("address").set(opAddr);
        final String name = address.getLastElement().getValue();
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceRegistry serviceRegistry = context.getServiceRegistry();
                    ServiceController controller = serviceRegistry.getService(LogServices.handlerName(name));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void listenerAdded(ServiceController<?> serviceController) {
                                serviceController.setMode(ServiceController.Mode.ACTIVE);
                            }

                            public void serviceStarted(ServiceController<?> serviceController) {
                                resultHandler.handleResultComplete();
                            }
                        });
                    } else {
                        resultHandler.handleResultComplete();
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

