/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class JMSDescriptions {
    static final String RESOURCE_NAME = JMSDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    JMSDescriptions() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    static ModelNode getSubsystem(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode subsystem = new ModelNode();
        subsystem.get("description").set(bundle.getString("jms"));
        subsystem.get("head-comment-allowed").set(true);
        subsystem.get("tail-comment-allowed").set(true);
        subsystem.get("namespace").set(Namespace.JMS_1_0.getUriString());
        subsystem.get("attributes").setEmptyObject();
        subsystem.get("operations");
        subsystem.get(new String[]{"children", "connection-factory", "description"}).set(bundle.getString("jms.connection-factories"));
        subsystem.get(new String[]{"children", "queue", "description"}).set(bundle.getString("jms.queues"));
        subsystem.get(new String[]{"children", "topic", "description"}).set(bundle.getString("jms.topics"));
        return subsystem;
    }

    static ModelNode getSubsystemAdd(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("jms.add"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getSubsystemDescribe(Locale locale) {
        return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
    }

    static ModelNode getQueue(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("queue"));
        JMSDescriptions.addQueueProperties(bundle, node, "attributes");
        return node;
    }

    static ModelNode getQueueAdd(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("queue.add"));
        JMSDescriptions.addQueueProperties(bundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static void addQueueProperties(ResourceBundle bundle, ModelNode node, String propType) {
        node.get(new String[]{propType, "entries", "description"}).set(bundle.getString("queue.entries"));
        node.get(new String[]{propType, "entries", "type"}).set(ModelType.LIST);
        node.get(new String[]{propType, "entries", "min-length"}).set(1);
        node.get(new String[]{propType, "entries", "value-type"}).set(ModelType.STRING);
        node.get(new String[]{propType, "selector", "description"}).set(bundle.getString("queue.selector"));
        node.get(new String[]{propType, "selector", "type"}).set(ModelType.STRING);
        node.get(new String[]{propType, "selector", "nillable"}).set(true);
        node.get(new String[]{propType, "selector", "required"}).set(false);
        node.get(new String[]{propType, "durable", "description"}).set(bundle.getString("queue.durable"));
        node.get(new String[]{propType, "durable", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{propType, "durable", "required"}).set(false);
        node.get(new String[]{propType, "durable", "default"}).set(false);
    }

    static ModelNode getQueueRemove(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("queue.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getTopic(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("topic"));
        JMSDescriptions.addTopicProperties(bundle, node, "attributes");
        return node;
    }

    static ModelNode getTopicAdd(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("topic.add"));
        JMSDescriptions.addTopicProperties(bundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static void addTopicProperties(ResourceBundle bundle, ModelNode node, String propType) {
        node.get(new String[]{propType, "entries", "description"}).set(bundle.getString("topic.entries"));
        node.get(new String[]{propType, "entries", "type"}).set(ModelType.LIST);
        node.get(new String[]{propType, "entries", "min-length"}).set(1);
        node.get(new String[]{propType, "entries", "value-type"}).set(ModelType.STRING);
    }

    static ModelNode getTopicRemove(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("topic.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectionFactory(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("connection-factory"));
        JMSDescriptions.addConnectionFactoryProperties(bundle, node, "attributes");
        return node;
    }

    static ModelNode getConnectionFactoryAdd(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("connection-factory.add"));
        JMSDescriptions.addConnectionFactoryProperties(bundle, node, "request-properties");
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static void addConnectionFactoryProperties(ResourceBundle bundle, ModelNode node, String propType) {
        for (JMSServices.NodeAttribute attr : JMSServices.CONNECTION_FACTORY_ATTRS) {
            node.get(new String[]{propType, attr.getName(), "description"}).set(bundle.getString("connection-factory." + attr.getName()));
            node.get(new String[]{propType, attr.getName(), "type"}).set(attr.getType());
            node.get(new String[]{propType, attr.getName(), "required"}).set(attr.isRequired());
            if (attr.getName().equals("connector")) {
                node.get(new String[]{propType, attr.getName(), "value-type"}).set(JMSDescriptions.getConnectionFactoryConnectionValueType(bundle, propType));
                continue;
            }
            if (attr.getValueType() == null) continue;
            node.get(new String[]{propType, attr.getName(), "value-type"}).set(attr.getValueType());
        }
    }

    private static ModelNode getConnectionFactoryConnectionValueType(ResourceBundle bundle, String propType) {
        ModelNode node = new ModelNode().set("TBD");
        return node;
    }

    static ModelNode getConnectionFactoryRemove(Locale locale) {
        ResourceBundle bundle = JMSDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("connection-factory.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }
}

