/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.BridgeRemove;
import org.jboss.as.messaging.BridgeWriteAttributeHandler;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.BroadcastGroupRemove;
import org.jboss.as.messaging.BroadcastGroupWriteAttributeHandler;
import org.jboss.as.messaging.ClusterConnectionAdd;
import org.jboss.as.messaging.ClusterConnectionRemove;
import org.jboss.as.messaging.ClusterConnectionWriteAttributeHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceAdd;
import org.jboss.as.messaging.ConnectorServiceParamAdd;
import org.jboss.as.messaging.ConnectorServiceParamRemove;
import org.jboss.as.messaging.ConnectorServiceParamWriteAttributeHandler;
import org.jboss.as.messaging.ConnectorServiceRemove;
import org.jboss.as.messaging.ConnectorServiceWriteAttributeHandler;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.DiscoveryGroupRemove;
import org.jboss.as.messaging.DiscoveryGroupWriteAttributeHandler;
import org.jboss.as.messaging.DivertAdd;
import org.jboss.as.messaging.DivertConfigurationWriteHandler;
import org.jboss.as.messaging.DivertRemove;
import org.jboss.as.messaging.GroupingHandlerAdd;
import org.jboss.as.messaging.GroupingHandlerRemove;
import org.jboss.as.messaging.GroupingHandlerWriteAttributeHandler;
import org.jboss.as.messaging.HornetQServerControlWriteHandler;
import org.jboss.as.messaging.MessagingSubsystemAdd;
import org.jboss.as.messaging.MessagingSubsystemDescribeHandler;
import org.jboss.as.messaging.MessagingSubsystemParser;
import org.jboss.as.messaging.MessagingSubsystemProviders;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.QueueConfigurationWriteHandler;
import org.jboss.as.messaging.QueueRemove;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryRemove;
import org.jboss.as.messaging.jms.ConnectionFactoryWriteAttributeHandler;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSQueueRemove;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.JMSTopicRemove;
import org.jboss.as.messaging.jms.JmsQueueConfigurationWriteHandler;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAdd;
import org.jboss.as.messaging.jms.PooledConnectionFactoryRemove;
import org.jboss.as.messaging.jms.PooledConnectionFactoryWriteAttributeHandler;
import org.jboss.as.messaging.jms.TopicConfigurationWriteHandler;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class MessagingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "messaging";
    private static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"messaging");
    private static final PathElement CFS_PATH = PathElement.pathElement((String)"connection-factory");
    private static final PathElement JMS_QUEUE_PATH = PathElement.pathElement((String)"jms-queue");
    private static final PathElement TOPIC_PATH = PathElement.pathElement((String)"jms-topic");
    private static final PathElement RA_PATH = PathElement.pathElement((String)"pooled-connection-factory");
    private static final PathElement BROADCAST_GROUP_PATH = PathElement.pathElement((String)"broadcast-group");
    private static final PathElement DISCOVERY_GROUP_PATH = PathElement.pathElement((String)"discovery-group");
    private static final PathElement DIVERT_PATH = PathElement.pathElement((String)"divert");
    private static final PathElement GROUPING_HANDLER_PATH = PathElement.pathElement((String)"grouping-handler");

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        subsystem.registerXMLElementWriter((XMLElementWriter)MessagingSubsystemParser.getInstance());
        ManagementResourceRegistration rootRegistration = subsystem.registerSubsystemModel(MessagingSubsystemProviders.SUBSYSTEM);
        rootRegistration.registerOperationHandler("add", (OperationStepHandler)MessagingSubsystemAdd.INSTANCE, (DescriptionProvider)MessagingSubsystemAdd.INSTANCE, false);
        rootRegistration.registerOperationHandler("describe", (OperationStepHandler)MessagingSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)MessagingSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        for (AttributeDefinition attributeDefinition : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            rootRegistration.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)HornetQServerControlWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration broadcastGroups = rootRegistration.registerSubModel(BROADCAST_GROUP_PATH, MessagingSubsystemProviders.BROADCAST_GROUP_RESOURCE);
        broadcastGroups.registerOperationHandler("add", (OperationStepHandler)BroadcastGroupAdd.INSTANCE, (DescriptionProvider)BroadcastGroupAdd.INSTANCE);
        broadcastGroups.registerOperationHandler("remove", (OperationStepHandler)BroadcastGroupRemove.INSTANCE, (DescriptionProvider)BroadcastGroupRemove.INSTANCE);
        for (AttributeDefinition attributeDefinition : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
            broadcastGroups.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)BroadcastGroupWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration discoveryGroups = rootRegistration.registerSubModel(DISCOVERY_GROUP_PATH, MessagingSubsystemProviders.DISCOVERY_GROUP_RESOURCE);
        discoveryGroups.registerOperationHandler("add", (OperationStepHandler)DiscoveryGroupAdd.INSTANCE, (DescriptionProvider)DiscoveryGroupAdd.INSTANCE);
        discoveryGroups.registerOperationHandler("remove", (OperationStepHandler)DiscoveryGroupRemove.INSTANCE, (DescriptionProvider)DiscoveryGroupRemove.INSTANCE);
        for (AttributeDefinition attributeDefinition : CommonAttributes.DISCOVERY_GROUP_ATTRIBUTES) {
            discoveryGroups.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)DiscoveryGroupWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration diverts = rootRegistration.registerSubModel(DIVERT_PATH, MessagingSubsystemProviders.DIVERT_RESOURCE);
        diverts.registerOperationHandler("add", (OperationStepHandler)DivertAdd.INSTANCE, (DescriptionProvider)DivertAdd.INSTANCE);
        diverts.registerOperationHandler("remove", (OperationStepHandler)DivertRemove.INSTANCE, (DescriptionProvider)DivertRemove.INSTANCE);
        for (AttributeDefinition attributeDefinition : CommonAttributes.DIVERT_ATTRIBUTES) {
            diverts.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)DivertConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration queue = rootRegistration.registerSubModel(PathElement.pathElement((String)"queue"), MessagingSubsystemProviders.QUEUE_RESOURCE);
        queue.registerOperationHandler("add", (OperationStepHandler)QueueAdd.INSTANCE, (DescriptionProvider)QueueAdd.INSTANCE, false);
        queue.registerOperationHandler("remove", (OperationStepHandler)QueueRemove.INSTANCE, (DescriptionProvider)QueueRemove.INSTANCE, false);
        for (AttributeDefinition attributeDefinition : CommonAttributes.CORE_QUEUE_ATTRIBUTES) {
            queue.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)QueueConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration bridge = rootRegistration.registerSubModel(PathElement.pathElement((String)"bridge"), MessagingSubsystemProviders.BRIDGE_RESOURCE);
        bridge.registerOperationHandler("add", (OperationStepHandler)BridgeAdd.INSTANCE, (DescriptionProvider)BridgeAdd.INSTANCE, false);
        bridge.registerOperationHandler("remove", (OperationStepHandler)BridgeRemove.INSTANCE, (DescriptionProvider)BridgeRemove.INSTANCE, false);
        for (AttributeDefinition attributeDefinition : CommonAttributes.BRIDGE_ATTRIBUTES) {
            bridge.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)BridgeWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration cluster = rootRegistration.registerSubModel(PathElement.pathElement((String)"cluster-connection"), MessagingSubsystemProviders.CLUSTER_CONNECTION_RESOURCE);
        cluster.registerOperationHandler("add", (OperationStepHandler)ClusterConnectionAdd.INSTANCE, (DescriptionProvider)ClusterConnectionAdd.INSTANCE, false);
        cluster.registerOperationHandler("remove", (OperationStepHandler)ClusterConnectionRemove.INSTANCE, (DescriptionProvider)ClusterConnectionRemove.INSTANCE, false);
        for (AttributeDefinition attributeDefinition : CommonAttributes.CLUSTER_CONNECTION_ATTRIBUTES) {
            cluster.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)ClusterConnectionWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration groupingHandler = rootRegistration.registerSubModel(GROUPING_HANDLER_PATH, MessagingSubsystemProviders.GROUPING_HANDLER_RESOURCE);
        groupingHandler.registerOperationHandler("add", (OperationStepHandler)GroupingHandlerAdd.INSTANCE, (DescriptionProvider)GroupingHandlerAdd.INSTANCE);
        groupingHandler.registerOperationHandler("remove", (OperationStepHandler)GroupingHandlerRemove.INSTANCE, (DescriptionProvider)GroupingHandlerRemove.INSTANCE);
        for (AttributeDefinition attributeDefinition : CommonAttributes.GROUPING_HANDLER_ATTRIBUTES) {
            groupingHandler.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)GroupingHandlerWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration connectorService = rootRegistration.registerSubModel(PathElement.pathElement((String)"connector-service"), MessagingSubsystemProviders.CONNECTOR_SERVICE_RESOURCE);
        connectorService.registerOperationHandler("add", (OperationStepHandler)ConnectorServiceAdd.INSTANCE, (DescriptionProvider)ConnectorServiceAdd.INSTANCE, false);
        connectorService.registerOperationHandler("remove", (OperationStepHandler)ConnectorServiceRemove.INSTANCE, (DescriptionProvider)ConnectorServiceRemove.INSTANCE, false);
        for (AttributeDefinition attributeDefinition : CommonAttributes.CONNECTOR_SERVICE_ATTRIBUTES) {
            connectorService.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)ConnectorServiceWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration connectorServiceParam = connectorService.registerSubModel(PathElement.pathElement((String)"param"), MessagingSubsystemProviders.CONNECTOR_SERVICE_PARAM_RESOURCE);
        connectorServiceParam.registerOperationHandler("add", (OperationStepHandler)ConnectorServiceParamAdd.INSTANCE, (DescriptionProvider)ConnectorServiceParamAdd.INSTANCE, false);
        connectorServiceParam.registerOperationHandler("remove", (OperationStepHandler)ConnectorServiceParamRemove.INSTANCE, (DescriptionProvider)ConnectorServiceParamRemove.INSTANCE, false);
        connectorServiceParam.registerReadWriteAttribute(CommonAttributes.VALUE.getName(), null, (OperationStepHandler)ConnectorServiceParamWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration cfs = rootRegistration.registerSubModel(CFS_PATH, MessagingSubsystemProviders.CF);
        cfs.registerOperationHandler("add", (OperationStepHandler)ConnectionFactoryAdd.INSTANCE, MessagingSubsystemProviders.CF_ADD, false);
        cfs.registerOperationHandler("remove", (OperationStepHandler)ConnectionFactoryRemove.INSTANCE, MessagingSubsystemProviders.CF_REMOVE, false);
        for (AttributeDefinition attributeDefinition : JMSServices.CONNECTION_FACTORY_ATTRS) {
            cfs.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)ConnectionFactoryWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration resourceAdapters = rootRegistration.registerSubModel(RA_PATH, MessagingSubsystemProviders.RA);
        resourceAdapters.registerOperationHandler("add", (OperationStepHandler)PooledConnectionFactoryAdd.INSTANCE, MessagingSubsystemProviders.RA_ADD, false);
        resourceAdapters.registerOperationHandler("remove", (OperationStepHandler)PooledConnectionFactoryRemove.INSTANCE, MessagingSubsystemProviders.RA_REMOVE);
        for (AttributeDefinition attributeDefinition : JMSServices.POOLED_CONNECTION_FACTORY_ATTRS) {
            resourceAdapters.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)PooledConnectionFactoryWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration queues = rootRegistration.registerSubModel(JMS_QUEUE_PATH, MessagingSubsystemProviders.JMS_QUEUE_RESOURCE);
        queues.registerOperationHandler("add", (OperationStepHandler)JMSQueueAdd.INSTANCE, (DescriptionProvider)JMSQueueAdd.INSTANCE, false);
        queues.registerOperationHandler("remove", (OperationStepHandler)JMSQueueRemove.INSTANCE, (DescriptionProvider)JMSQueueRemove.INSTANCE, false);
        for (AttributeDefinition attributeDefinition : CommonAttributes.JMS_QUEUE_ATTRIBUTES) {
            queues.registerReadWriteAttribute(attributeDefinition.getName(), null, (OperationStepHandler)JmsQueueConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        }
        ManagementResourceRegistration topics = rootRegistration.registerSubModel(TOPIC_PATH, MessagingSubsystemProviders.JMS_TOPIC_RESOURCE);
        topics.registerOperationHandler("add", (OperationStepHandler)JMSTopicAdd.INSTANCE, (DescriptionProvider)JMSTopicAdd.INSTANCE, false);
        topics.registerOperationHandler("remove", (OperationStepHandler)JMSTopicRemove.INSTANCE, (DescriptionProvider)JMSTopicRemove.INSTANCE, false);
        topics.registerReadWriteAttribute(CommonAttributes.ENTRIES.getName(), null, (OperationStepHandler)TopicConfigurationWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.MESSAGING_1_0.getUriString(), (XMLElementReader)MessagingSubsystemParser.getInstance());
    }
}

