/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.management.MBeanServer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.remoting.impl.invm.InVMAcceptorFactory;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.ClusterConnectionAdd;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceAdd;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.DivertAdd;
import org.jboss.as.messaging.GroupingHandlerAdd;
import org.jboss.as.messaging.HornetQService;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.jms.JMSService;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class MessagingSubsystemAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    private static final String DEFAULT_PATH = "messaging";
    private static final String DEFAULT_RELATIVE_TO = "jboss.server.data.dir";
    private static final ServiceName PATH_BASE = MessagingServices.JBOSS_MESSAGING.append(new String[]{"paths"});
    static final String DEFAULT_BINDINGS_DIR = "bindings";
    static final String DEFAULT_JOURNAL_DIR = "journal";
    static final String DEFAULT_LARGE_MESSSAGE_DIR = "largemessages";
    static final String DEFAULT_PAGING_DIR = "paging";
    public static final MessagingSubsystemAdd INSTANCE = new MessagingSubsystemAdd();

    private MessagingSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
        for (AttributeDefinition attributeDefinition : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        for (String string : CommonAttributes.COMPLEX_ROOT_RESOURCE_ATTRIBUTES) {
            if (!operation.hasDefined(string)) continue;
            model.get(string).set(operation.get(string));
        }
        model.get("queue");
        model.get("connection-factory").setEmptyObject();
        model.get("jms-queue").setEmptyObject();
        model.get("jms-topic").setEmptyObject();
        model.get("pooled-connection-factory").setEmptyObject();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, final ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) throws OperationFailedException {
        final ServiceTarget serviceTarget = context.getServiceTarget();
        final ServiceName bindingsPath = MessagingSubsystemAdd.createDirectoryService(DEFAULT_BINDINGS_DIR, operation.get("bindings-directory"), serviceTarget);
        final ServiceName journalPath = MessagingSubsystemAdd.createDirectoryService(DEFAULT_JOURNAL_DIR, operation.get("journal-directory"), serviceTarget);
        final ServiceName largeMessagePath = MessagingSubsystemAdd.createDirectoryService(DEFAULT_LARGE_MESSSAGE_DIR, operation.get("large-messages-directory"), serviceTarget);
        final ServiceName pagingPath = MessagingSubsystemAdd.createDirectoryService(DEFAULT_PAGING_DIR, operation.get("paging-directory"), serviceTarget);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Configuration configuration = MessagingSubsystemAdd.this.transformConfig(model);
                HashSet<String> socketBindings = new HashSet<String>();
                MessagingSubsystemAdd.processAcceptors(configuration, operation, socketBindings);
                MessagingSubsystemAdd.processConnectors(configuration, operation, socketBindings);
                HornetQService hqService = new HornetQService();
                hqService.setConfiguration(configuration);
                ServiceBuilder serviceBuilder = serviceTarget.addService(MessagingServices.JBOSS_MESSAGING, (Service)hqService).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, hqService.getMBeanServer());
                serviceBuilder.addDependency(bindingsPath, String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_BINDINGS_DIR));
                serviceBuilder.addDependency(journalPath, String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_JOURNAL_DIR));
                serviceBuilder.addDependency(largeMessagePath, String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_LARGE_MESSSAGE_DIR));
                serviceBuilder.addDependency(pagingPath, String.class, hqService.getPathInjector(MessagingSubsystemAdd.DEFAULT_PAGING_DIR));
                for (String socketBinding : socketBindings) {
                    ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketBinding});
                    serviceBuilder.addDependency(socketName, SocketBinding.class, hqService.getSocketBindingInjector(socketBinding));
                }
                serviceBuilder.addListener((ServiceListener)verificationHandler);
                newControllers.add(serviceBuilder.install());
                newControllers.add(JMSService.addService(serviceTarget, new ServiceListener[]{verificationHandler}));
                context.completeStep();
            }
        }, OperationContext.Stage.RUNTIME);
    }

    Configuration transformConfig(ModelNode model) throws OperationFailedException {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setAllowAutoFailBack(CommonAttributes.ALLOW_FAILBACK.validateResolvedOperation(model).asBoolean());
        configuration.setEnabledAsyncConnectionExecution(CommonAttributes.ASYNC_CONNECTION_EXECUTION_ENABLED.validateResolvedOperation(model).asBoolean());
        configuration.setBackup(CommonAttributes.BACKUP.validateResolvedOperation(model).asBoolean());
        if (model.hasDefined(CommonAttributes.LIVE_CONNECTOR_REF.getName())) {
            configuration.setLiveConnectorName(CommonAttributes.LIVE_CONNECTOR_REF.validateResolvedOperation(model).asString());
        }
        configuration.setClustered(CommonAttributes.CLUSTERED.validateResolvedOperation(model).asBoolean());
        configuration.setClusterPassword(CommonAttributes.CLUSTER_PASSWORD.validateResolvedOperation(model).asString());
        configuration.setClusterUser(CommonAttributes.CLUSTER_USER.validateResolvedOperation(model).asString());
        configuration.setConnectionTTLOverride((long)CommonAttributes.CONNECTION_TTL_OVERRIDE.validateResolvedOperation(model).asInt());
        configuration.setCreateBindingsDir(CommonAttributes.CREATE_BINDINGS_DIR.validateResolvedOperation(model).asBoolean());
        configuration.setCreateJournalDir(CommonAttributes.CREATE_JOURNAL_DIR.validateResolvedOperation(model).asBoolean());
        configuration.setFailbackDelay(CommonAttributes.FAILBACK_DELAY.validateResolvedOperation(model).asLong());
        configuration.setFailoverOnServerShutdown(CommonAttributes.FAILOVER_ON_SHUTDOWN.validateResolvedOperation(model).asBoolean());
        configuration.setIDCacheSize(CommonAttributes.ID_CACHE_SIZE.validateResolvedOperation(model).asInt());
        configuration.setJMXDomain(CommonAttributes.JMX_DOMAIN.validateResolvedOperation(model).asString());
        configuration.setJMXManagementEnabled(CommonAttributes.JMX_MANAGEMENT_ENABLED.validateResolvedOperation(model).asBoolean());
        JournalType journalType = JournalType.valueOf((String)CommonAttributes.JOURNAL_TYPE.validateResolvedOperation(model).asString());
        configuration.setJournalType(journalType);
        configuration.setJournalBufferSize_AIO(CommonAttributes.JOURNAL_BUFFER_SIZE.validateResolvedOperation(model).asInt(501760));
        configuration.setJournalBufferTimeout_AIO(CommonAttributes.JOURNAL_BUFFER_TIMEOUT.validateResolvedOperation(model).asInt(500000));
        configuration.setJournalMaxIO_AIO(CommonAttributes.JOURNAL_MAX_IO.validateResolvedOperation(model).asInt(500));
        configuration.setJournalBufferSize_NIO(CommonAttributes.JOURNAL_BUFFER_SIZE.validateResolvedOperation(model).asInt(501760));
        configuration.setJournalBufferTimeout_NIO(CommonAttributes.JOURNAL_BUFFER_TIMEOUT.validateResolvedOperation(model).asInt(3333333));
        configuration.setJournalMaxIO_NIO(CommonAttributes.JOURNAL_MAX_IO.validateResolvedOperation(model).asInt(1));
        configuration.setJournalCompactMinFiles(CommonAttributes.JOURNAL_COMPACT_MIN_FILES.validateResolvedOperation(model).asInt());
        configuration.setJournalCompactPercentage(CommonAttributes.JOURNAL_COMPACT_PERCENTAGE.validateResolvedOperation(model).asInt());
        configuration.setJournalFileSize(CommonAttributes.JOURNAL_FILE_SIZE.validateResolvedOperation(model).asInt());
        configuration.setJournalMinFiles(CommonAttributes.JOURNAL_MIN_FILES.validateResolvedOperation(model).asInt());
        configuration.setJournalSyncNonTransactional(CommonAttributes.JOURNAL_SYNC_NON_TRANSACTIONAL.validateResolvedOperation(model).asBoolean());
        configuration.setJournalSyncTransactional(CommonAttributes.JOURNAL_SYNC_TRANSACTIONAL.validateResolvedOperation(model).asBoolean());
        configuration.setLogJournalWriteRate(CommonAttributes.LOG_JOURNAL_WRITE_RATE.validateResolvedOperation(model).asBoolean());
        configuration.setManagementAddress(SimpleString.toSimpleString((String)CommonAttributes.MANAGEMENT_ADDRESS.validateResolvedOperation(model).asString()));
        configuration.setManagementNotificationAddress(SimpleString.toSimpleString((String)CommonAttributes.MANAGEMENT_NOTIFICATION_ADDRESS.validateResolvedOperation(model).asString()));
        configuration.setMemoryMeasureInterval(CommonAttributes.MEMORY_MEASURE_INTERVAL.validateResolvedOperation(model).asLong());
        configuration.setMemoryWarningThreshold(CommonAttributes.MEMORY_WARNING_THRESHOLD.validateResolvedOperation(model).asInt());
        configuration.setMessageCounterEnabled(CommonAttributes.MESSAGE_COUNTER_ENABLED.validateResolvedOperation(model).asBoolean());
        configuration.setMessageCounterSamplePeriod((long)CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD.validateResolvedOperation(model).asInt());
        configuration.setMessageCounterMaxDayHistory(CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY.validateResolvedOperation(model).asInt());
        configuration.setMessageExpiryScanPeriod(CommonAttributes.MESSAGE_EXPIRY_SCAN_PERIOD.validateResolvedOperation(model).asLong());
        configuration.setMessageExpiryThreadPriority(CommonAttributes.MESSAGE_EXPIRY_THREAD_PRIORITY.validateResolvedOperation(model).asInt());
        if (model.hasDefined(CommonAttributes.NAME_OPTIONAL.getName())) {
            configuration.setName(CommonAttributes.NAME_OPTIONAL.validateResolvedOperation(model).asString());
        }
        configuration.setJournalPerfBlastPages(CommonAttributes.PERF_BLAST_PAGES.validateResolvedOperation(model).asInt());
        configuration.setPersistDeliveryCountBeforeDelivery(CommonAttributes.PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY.validateResolvedOperation(model).asBoolean());
        configuration.setPersistenceEnabled(CommonAttributes.PERSISTENCE_ENABLED.validateResolvedOperation(model).asBoolean());
        configuration.setPersistIDCache(CommonAttributes.PERSIST_ID_CACHE.validateResolvedOperation(model).asBoolean());
        configuration.setRunSyncSpeedTest(CommonAttributes.RUN_SYNC_SPEED_TEST.validateResolvedOperation(model).asBoolean());
        configuration.setScheduledThreadPoolMaxSize(CommonAttributes.SCHEDULED_THREAD_POOL_MAX_SIZE.validateResolvedOperation(model).asInt());
        configuration.setSecurityEnabled(CommonAttributes.SECURITY_ENABLED.validateResolvedOperation(model).asBoolean());
        configuration.setSecurityInvalidationInterval(CommonAttributes.SECURITY_INVALIDATION_INTERVAL.validateResolvedOperation(model).asLong());
        configuration.setServerDumpInterval(CommonAttributes.SERVER_DUMP_INTERVAL.validateResolvedOperation(model).asLong());
        configuration.setSharedStore(CommonAttributes.SHARED_STORE.validateResolvedOperation(model).asBoolean());
        configuration.setThreadPoolMaxSize(CommonAttributes.THREAD_POOL_MAX_SIZE.validateResolvedOperation(model).asInt());
        configuration.setTransactionTimeout(CommonAttributes.TRANSACTION_TIMEOUT.validateResolvedOperation(model).asLong());
        configuration.setTransactionTimeoutScanPeriod(CommonAttributes.TRANSACTION_TIMEOUT_SCAN_PERIOD.validateResolvedOperation(model).asLong());
        configuration.setWildcardRoutingEnabled(CommonAttributes.WILD_CARD_ROUTING_ENABLED.validateResolvedOperation(model).asBoolean());
        MessagingSubsystemAdd.processAddressSettings((Configuration)configuration, model);
        MessagingSubsystemAdd.processSecuritySettings((Configuration)configuration, model);
        GroupingHandlerAdd.addGroupingHandlerConfig((Configuration)configuration, model);
        BroadcastGroupAdd.addBroadcastGroupConfigs((Configuration)configuration, model);
        DiscoveryGroupAdd.addDiscoveryGroupConfigs((Configuration)configuration, model);
        DivertAdd.addDivertConfigs((Configuration)configuration, model);
        QueueAdd.addQueueConfigs((Configuration)configuration, model);
        BridgeAdd.addBridgeConfigs((Configuration)configuration, model);
        ClusterConnectionAdd.addClusterConnectionConfigs((Configuration)configuration, model);
        ConnectorServiceAdd.addConnectorServiceConfigs((Configuration)configuration, model);
        return configuration;
    }

    static void processAcceptors(Configuration configuration, ModelNode params, Set<String> bindings) {
        if (params.hasDefined("acceptor")) {
            HashMap<String, TransportConfiguration> acceptors = new HashMap<String, TransportConfiguration>();
            for (Property property : params.get("acceptor").asPropertyList()) {
                String clazz;
                String acceptorName = property.getName();
                ModelNode config = property.getValue();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                if (config.get("param").isDefined()) {
                    for (Property parameter : config.get("param").asPropertyList()) {
                        parameters.put(parameter.getName(), parameter.getValue().asString());
                    }
                }
                MessagingServices.TransportConfigType type = MessagingServices.TransportConfigType.valueOf(config.get("type").asString());
                switch (type) {
                    case Remote: {
                        clazz = NettyAcceptorFactory.class.getName();
                        String binding = config.get("socket-binding").asString();
                        parameters.put("socket-binding", binding);
                        bindings.add(binding);
                        break;
                    }
                    case InVM: {
                        clazz = InVMAcceptorFactory.class.getName();
                        parameters.put("server-id", config.get("server-id").asInt());
                        break;
                    }
                    case Generic: {
                        clazz = config.get(CommonAttributes.FACTORY_CLASS.getName()).asString();
                        break;
                    }
                    default: {
                        clazz = null;
                    }
                }
                acceptors.put(acceptorName, new TransportConfiguration(clazz, parameters, acceptorName));
            }
            configuration.setAcceptorConfigurations(new HashSet(acceptors.values()));
        }
    }

    static void processConnectors(Configuration configuration, ModelNode params, Set<String> bindings) {
        if (params.hasDefined("connector")) {
            HashMap<String, TransportConfiguration> connectors = new HashMap<String, TransportConfiguration>();
            for (Property property : params.get("connector").asPropertyList()) {
                String clazz;
                String connectorName = property.getName();
                ModelNode config = property.getValue();
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                if (config.get("param").isDefined()) {
                    for (Property parameter : config.get("param").asPropertyList()) {
                        parameters.put(parameter.getName(), parameter.getValue().asString());
                    }
                }
                MessagingServices.TransportConfigType type = MessagingServices.TransportConfigType.valueOf(config.get("type").asString());
                switch (type) {
                    case Remote: {
                        clazz = NettyConnectorFactory.class.getName();
                        String binding = config.get("socket-binding").asString();
                        parameters.put("socket-binding", binding);
                        bindings.add(binding);
                        break;
                    }
                    case InVM: {
                        clazz = InVMConnectorFactory.class.getName();
                        parameters.put("server-id", config.get("server-id").asInt());
                        break;
                    }
                    case Generic: {
                        clazz = config.get(CommonAttributes.FACTORY_CLASS.getName()).asString();
                        break;
                    }
                    default: {
                        clazz = null;
                    }
                }
                connectors.put(connectorName, new TransportConfiguration(clazz, parameters, connectorName));
            }
            configuration.setConnectorConfigurations(connectors);
        }
    }

    static void processAddressSettings(Configuration configuration, ModelNode params) {
        if (params.get("address-setting").isDefined()) {
            for (Property property : params.get("address-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                AddressSettings settings = new AddressSettings();
                AddressFullMessagePolicy addressPolicy = config.hasDefined("address-full-policy") ? AddressFullMessagePolicy.valueOf((String)config.get("address-full-policy").asString()) : AddressSettings.DEFAULT_ADDRESS_FULL_MESSAGE_POLICY;
                settings.setAddressFullMessagePolicy(addressPolicy);
                settings.setDeadLetterAddress(MessagingSubsystemAdd.asSimpleString(config.get("dead-letter-address"), null));
                settings.setLastValueQueue(config.get("last-value-queue").asBoolean(false));
                settings.setMaxDeliveryAttempts(config.get("max-delivery-attempts").asInt(10));
                settings.setMaxSizeBytes((long)config.get("max-size-bytes").asInt(-1));
                settings.setMessageCounterHistoryDayLimit(config.get("message-counter-history-day-limit").asInt(0));
                settings.setExpiryAddress(MessagingSubsystemAdd.asSimpleString(config.get("expiry-address"), null));
                settings.setRedeliveryDelay((long)config.get("redelivery-delay").asInt(0));
                settings.setRedistributionDelay((long)config.get("redistribution-delay").asInt(-1));
                settings.setPageSizeBytes((long)config.get("page-size-bytes").asInt(0xA00000));
                settings.setSendToDLAOnNoRoute(config.get("send-to-dla-on-no-route").asBoolean(false));
                configuration.getAddressesSettings().put(match, settings);
            }
        }
    }

    static void processSecuritySettings(Configuration configuration, ModelNode params) {
        if (params.get("security-setting").isDefined()) {
            for (Property property : params.get("security-setting").asPropertyList()) {
                String match = property.getName();
                ModelNode config = property.getValue();
                if (config.getType() == ModelType.UNDEFINED) continue;
                HashSet<Role> roles = new HashSet<Role>();
                for (Property role : config.asPropertyList()) {
                    String name = role.getName();
                    ModelNode value = role.getValue();
                    roles.add(new Role(name, value.get("send").asBoolean(false), value.get("consume").asBoolean(false), value.get("createDurableQueue").asBoolean(false), value.get("deleteDurableQueue").asBoolean(false), value.get("createNonDurableQueue").asBoolean(false), value.get("deleteNonDurableQueue").asBoolean(false), value.get("manage").asBoolean(false)));
                }
                configuration.getSecurityRoles().put(match, roles);
            }
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getSubsystemAdd(locale);
    }

    static ServiceName createDirectoryService(String name, ModelNode path, ServiceTarget serviceTarget) {
        ServiceName serviceName = PATH_BASE.append(new String[]{name});
        String relativeTo = path.hasDefined("relative-to") ? path.get("relative-to").asString() : DEFAULT_RELATIVE_TO;
        String pathName = path.hasDefined("path") ? path.get("path").asString() : DEFAULT_PATH + name;
        RelativePathService.addService((ServiceName)serviceName, (String)pathName, (String)relativeTo, (ServiceTarget)serviceTarget);
        return serviceName;
    }

    static SimpleString asSimpleString(ModelNode node, String defVal) {
        return SimpleString.toSimpleString((String)(node.getType() != ModelType.UNDEFINED ? node.asString() : defVal));
    }
}

