/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.messaging.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ConnectorRefsAttribute
extends ListAttributeDefinition {
    public static final ConnectorRefsAttribute CLUSTER_CONNECTION_CONNECTORS = new ConnectorRefsAttribute("static-connectors", false, true);
    public static final ConnectorRefsAttribute BRIDGE_CONNECTORS = new ConnectorRefsAttribute("static-connectors", true, true);
    public static final ConnectorRefsAttribute BROADCAST_GROUP = new ConnectorRefsAttribute("connectors", false, true);
    private final boolean wrap;

    private ConnectorRefsAttribute(String name, boolean wrap, boolean allowNull) {
        super(name, "connector-ref", allowNull, 1, Integer.MAX_VALUE, (ParameterValidator)new StringLengthValidator(1));
        this.wrap = wrap;
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        List list;
        if (resourceModel.hasDefined(this.getName()) && (list = resourceModel.get(this.getName()).asList()).size() > 0) {
            if (this.wrap) {
                writer.writeStartElement(Element.STATIC_CONNECTORS.getLocalName());
            }
            for (ModelNode child : list) {
                writer.writeStartElement(this.getXmlName());
                writer.writeCharacters(child.asString());
                writer.writeEndElement();
            }
            if (this.wrap) {
                writer.writeEndElement();
            }
        }
    }

    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        node.get("value-type").set(ModelType.STRING);
    }
}

