/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.messaging.AddressSettingAdd;
import org.jboss.as.messaging.BridgeAdd;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.ClusterConnectionAdd;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceAdd;
import org.jboss.as.messaging.ConnectorServiceParamAdd;
import org.jboss.as.messaging.DiscoveryGroupAdd;
import org.jboss.as.messaging.DivertAdd;
import org.jboss.as.messaging.GroupingHandlerAdd;
import org.jboss.as.messaging.MessagingPathHandlers;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.SecurityRoleAdd;
import org.jboss.as.messaging.SecuritySettingAdd;
import org.jboss.as.messaging.TransportConfigOperationHandlers;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class MessagingSubsystemDescribeHandler
implements OperationStepHandler,
DescriptionProvider {
    static final String[] TRANSPORT = new String[]{"acceptor", "remote-acceptor", "in-vm-acceptor", "connector", "remote-connector", "in-vm-connector"};
    static final MessagingSubsystemDescribeHandler INSTANCE = new MessagingSubsystemDescribeHandler();

    MessagingSubsystemDescribeHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode subsystemAdd = new ModelNode();
        ModelNode subModel = context.readModel(PathAddress.EMPTY_ADDRESS);
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(rootAddress.toModelNode());
        for (AttributeDefinition attribute : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            String attrName = attribute.getName();
            if (!subModel.hasDefined(attrName)) continue;
            subsystemAdd.get(attrName).set(subModel.get(attrName));
        }
        ModelNode result = context.getResult();
        result.add(subsystemAdd);
        for (String transport : TRANSPORT) {
            if (!subModel.hasDefined(transport)) continue;
            for (Property property : subModel.get(transport).asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add(transport, property.getName());
                result.add(TransportConfigOperationHandlers.createAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("path")) {
            ModelNode paths = subModel.get("path");
            for (String pathName : CommonAttributes.PATHS) {
                if (!paths.hasDefined(pathName)) continue;
                ModelNode address = rootAddress.toModelNode();
                address.add("path", pathName);
                result.add(MessagingPathHandlers.createAddOperation(address, paths.get(pathName)));
            }
        }
        if (subModel.hasDefined("address-setting")) {
            for (Property property : subModel.get("address-setting").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("address-setting", property.getName());
                result.add(AddressSettingAdd.createAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("broadcast-group")) {
            for (Property property : subModel.get("broadcast-group").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("broadcast-group", property.getName());
                result.add(BroadcastGroupAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("discovery-group")) {
            for (Property property : subModel.get("discovery-group").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("discovery-group", property.getName());
                result.add(DiscoveryGroupAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("divert")) {
            for (Property property : subModel.get("divert").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("divert", property.getName());
                result.add(DivertAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("queue")) {
            for (Property property : subModel.get("queue").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("queue", property.getName());
                result.add(QueueAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("bridge")) {
            for (Property property : subModel.get("bridge").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("bridge", property.getName());
                result.add(BridgeAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("cluster-connection")) {
            for (Property property : subModel.get("cluster-connection").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("cluster-connection", property.getName());
                result.add(ClusterConnectionAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("grouping-handler")) {
            Property property = subModel.get("grouping-handler").asProperty();
            ModelNode address = rootAddress.toModelNode();
            address.add("grouping-handler", property.getName());
            result.add(GroupingHandlerAdd.getAddOperation(address, property.getValue()));
        }
        if (subModel.hasDefined("connector-service")) {
            for (Property property : subModel.get("connector-service").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("connector-service", property.getName());
                ModelNode csNode = property.getValue();
                result.add(ConnectorServiceAdd.getAddOperation(address, csNode));
                if (!csNode.hasDefined("param")) continue;
                for (Property param : csNode.get("param").asPropertyList()) {
                    ModelNode paramAddress = address.clone().add("param", param.getName());
                    result.add(ConnectorServiceParamAdd.getAddOperation(paramAddress, param.getValue()));
                }
            }
        }
        if (subModel.hasDefined("connection-factory")) {
            for (Property property : subModel.get("connection-factory").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("connection-factory", property.getName());
                result.add(ConnectionFactoryAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("pooled-connection-factory")) {
            for (Property property : subModel.get("pooled-connection-factory").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("pooled-connection-factory", property.getName());
                result.add(PooledConnectionFactoryAdd.getAddOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("jms-queue")) {
            for (Property property : subModel.get("jms-queue").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("jms-queue", property.getName());
                result.add(JMSQueueAdd.getOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("jms-topic")) {
            for (Property property : subModel.get("jms-topic").asPropertyList()) {
                ModelNode address = rootAddress.toModelNode();
                address.add("jms-topic", property.getName());
                result.add(JMSTopicAdd.getOperation(address, property.getValue()));
            }
        }
        if (subModel.hasDefined("security-setting")) {
            ModelNode securitySettings = subModel.get("security-setting");
            for (Property setting : securitySettings.asPropertyList()) {
                ModelNode settingAddress = rootAddress.toModelNode();
                settingAddress.add("security-setting", setting.getName());
                result.add(SecuritySettingAdd.createAddOperation(settingAddress, setting.getValue()));
                ModelNode securitySetting = setting.getValue();
                if (!securitySetting.hasDefined("role")) continue;
                for (Property role : securitySetting.get("role").asPropertyList()) {
                    ModelNode address = settingAddress.clone();
                    address.add("role", role.getName());
                    result.add(SecurityRoleAdd.createAddOperation(address, role.getValue()));
                }
            }
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

